/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoDatabase;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.events.bukkit.CollectionCreateEvent;
import org.bukkit.event.Event;

@Name(value="Create Mongo Collection")
@Description(value={"This effect allows you to simply create a new Mongo collection in a database. The name must comply with the Mongo rules and those of your host."})
@Examples(value={"set {_database} to mongo database named \"mongosk\" of client named \"mongosk\"", "create a new mongo collection named \"example\" in {_database}"})
@Since(value="1.0.0")
public class EffCreateCollection
extends Effect {
    private Expression<String> exprName;
    private Expression<MongoDatabase> exprDatabase;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprDatabase = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        String name = (String)this.exprName.getSingle(e);
        MongoDatabase database = (MongoDatabase)this.exprDatabase.getSingle(e);
        if (name == null || database == null) {
            return;
        }
        try {
            MongoNamespace.checkCollectionNameValidity(name);
            database.createCollection(name);
            MongoSK.getPluginManager().callEvent((Event)new CollectionCreateEvent(database.getCollection(name)));
        }
        catch (MongoCommandException | IllegalArgumentException ex) {
            Skript.error((String)("Ups! There was an error. " + ex.getMessage()));
        }
    }

    public String toString(Event e, boolean debug) {
        return "create a new mongo collection collection named " + this.exprName.toString(e, debug) + " in " + this.exprDatabase.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCreateCollection.class, (String[])new String[]{"create [a] [new] [mongo[db]] collection [(named|with name|called)] %string% in %mongodatabase%"});
    }
}

