/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.MongoManager;
import fr.romitou.mongosk.skript.events.bukkit.ClientCreateEvent;
import org.bukkit.event.Event;

@Name(value="Create Mongo Client")
@Description(value={"This effect allows you to create a new client, a new connection to a Mongo host. The name you will give to this client will help you to identify it more easily later."})
@Examples(value={"create a new mongo client to host \"mongodb://127.0.0.1\" as \"mongosk\""})
@Since(value="1.0.0")
public class EffCreateClient
extends Effect {
    private Expression<String> exprUri;
    private Expression<String> exprName;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprUri = exprs[0];
        this.exprName = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        String uri = (String)this.exprUri.getSingle(e);
        String name = (String)this.exprName.getSingle(e);
        if (uri == null || name == null) {
            return;
        }
        try {
            MongoClient mongoClient = MongoClients.create(MongoClientSettings.builder().applyConnectionString(new ConnectionString(uri)).build());
            MongoManager.addClient(mongoClient, name);
            MongoSK.getPluginManager().callEvent((Event)new ClientCreateEvent(mongoClient));
        }
        catch (IllegalArgumentException ex) {
            Skript.error((String)("Something went wrong. " + ex.getMessage()));
        }
    }

    public String toString(Event e, boolean debug) {
        return "create a new mongo client to server " + this.exprUri.toString(e, debug) + " with name " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCreateClient.class, (String[])new String[]{"connect to [the] mongo[db] [(server|host)] %string% (named|with name|as) %string%", "create [a] [new] mongo[db] client to [(server|host)] %string% (named|with name|as) %string%"});
    }
}

