/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoClient;
import fr.romitou.mongosk.MongoSK;
import fr.romitou.mongosk.skript.MongoManager;
import fr.romitou.mongosk.skript.events.bukkit.ClientCloseEvent;
import org.bukkit.event.Event;

@Name(value="Close Mongo Client")
@Description(value={"This effect allows you to close the connection of a Mongo client to the host. This means that no more queries can be made with this client."})
@Examples(value={"close mongo connection of client named \"mongosk\""})
@Since(value="1.0.0")
public class EffCloseClient
extends Effect {
    private Expression<MongoClient> exprClient;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprClient = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        MongoClient client = (MongoClient)this.exprClient.getSingle(e);
        if (client == null) {
            return;
        }
        client.close();
        MongoSK.getPluginManager().callEvent((Event)new ClientCloseEvent(client));
        MongoManager.removeClient(client);
    }

    public String toString(Event e, boolean debug) {
        return "close " + this.exprClient.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCloseClient.class, (String[])new String[]{"close [mongo[db]] connection [of] %mongoclient%"});
    }
}

