/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client.gridfs;

import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.internal.async.client.AsyncListIndexesIterable;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.gridfs.GridFSIndexCheck;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Map;
import org.bson.Document;

final class GridFSIndexCheckImpl
implements GridFSIndexCheck {
    private static final Document PROJECTION = new Document("_id", 1);
    private final AsyncClientSession clientSession;
    private final AsyncMongoCollection<GridFSFile> filesCollection;
    private final AsyncMongoCollection<Document> chunksCollection;

    GridFSIndexCheckImpl(@Nullable AsyncClientSession clientSession, AsyncMongoCollection<GridFSFile> filesCollection, AsyncMongoCollection<Document> chunksCollection) {
        this.clientSession = clientSession;
        this.filesCollection = Assertions.notNull("files collection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunks collection", chunksCollection);
    }

    @Override
    public void checkAndCreateIndex(final SingleResultCallback<Void> callback) {
        AsyncMongoCollection<Document> collection = this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary());
        AsyncFindIterable<Document> findIterable = this.clientSession != null ? collection.find(this.clientSession) : collection.find();
        findIterable.projection(PROJECTION).first(new SingleResultCallback<Document>(){

            @Override
            public void onResult(Document result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result == null) {
                    GridFSIndexCheckImpl.this.checkFilesIndex(callback);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    private <T> void hasIndex(AsyncMongoCollection<T> collection, final Document index, final SingleResultCallback<Boolean> callback) {
        AsyncListIndexesIterable<Document> listIndexesIterable = this.clientSession != null ? collection.listIndexes(this.clientSession) : collection.listIndexes();
        listIndexesIterable.into(new ArrayList(), new SingleResultCallback<ArrayList<Document>>(){

            @Override
            public void onResult(ArrayList<Document> indexes, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    boolean hasIndex = false;
                    for (Document result : indexes) {
                        Document indexDoc = result.get((Object)"key", new Document());
                        for (Map.Entry<String, Object> entry : indexDoc.entrySet()) {
                            if (!(entry.getValue() instanceof Number)) continue;
                            entry.setValue(((Number)entry.getValue()).intValue());
                        }
                        if (!indexDoc.equals(index)) continue;
                        hasIndex = true;
                        break;
                    }
                    callback.onResult(hasIndex, null);
                }
            }
        });
    }

    private void checkFilesIndex(final SingleResultCallback<Void> callback) {
        final Document filesIndex = new Document("filename", 1).append("uploadDate", 1);
        this.hasIndex(this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex, new SingleResultCallback<Boolean>(){

            @Override
            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    SingleResultCallback<String> createIndexCallback = new SingleResultCallback<String>(){

                        @Override
                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                GridFSIndexCheckImpl.this.checkChunksIndex(callback);
                            }
                        }
                    };
                    if (GridFSIndexCheckImpl.this.clientSession != null) {
                        GridFSIndexCheckImpl.this.filesCollection.createIndex(GridFSIndexCheckImpl.this.clientSession, filesIndex, createIndexCallback);
                    } else {
                        GridFSIndexCheckImpl.this.filesCollection.createIndex(filesIndex, createIndexCallback);
                    }
                } else {
                    GridFSIndexCheckImpl.this.checkChunksIndex(callback);
                }
            }
        });
    }

    private void checkChunksIndex(final SingleResultCallback<Void> callback) {
        final Document chunksIndex = new Document("files_id", 1).append("n", 1);
        this.hasIndex(this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex, new SingleResultCallback<Boolean>(){

            @Override
            public void onResult(Boolean result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (!result.booleanValue()) {
                    SingleResultCallback<String> createIndexCallback = new SingleResultCallback<String>(){

                        @Override
                        public void onResult(String result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult(null, null);
                            }
                        }
                    };
                    if (GridFSIndexCheckImpl.this.clientSession != null) {
                        GridFSIndexCheckImpl.this.chunksCollection.createIndex(GridFSIndexCheckImpl.this.clientSession, chunksIndex, new IndexOptions().unique(true), createIndexCallback);
                    } else {
                        GridFSIndexCheckImpl.this.chunksCollection.createIndex(chunksIndex, new IndexOptions().unique(true), createIndexCallback);
                    }
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }
}

