/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSUploadStream;
import com.mongodb.internal.async.client.gridfs.GridFSIndexCheck;
import com.mongodb.lang.Nullable;
import java.nio.ByteBuffer;
import java.util.Date;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

final class AsyncGridFSUploadStreamImpl
implements AsyncGridFSUploadStream {
    private static final Logger LOGGER = Loggers.getLogger("client.gridfs");
    private final AsyncClientSession clientSession;
    private final AsyncMongoCollection<GridFSFile> filesCollection;
    private final AsyncMongoCollection<Document> chunksCollection;
    private final BsonValue fileId;
    private final String filename;
    private final int chunkSizeBytes;
    private final Document metadata;
    private final GridFSIndexCheck indexCheck;
    private final Object closeAndWritingLock = new Object();
    private boolean checkedIndexes;
    private boolean writing;
    private boolean closed;
    private byte[] buffer;
    private long lengthInBytes;
    private int bufferOffset;
    private int chunkIndex;

    AsyncGridFSUploadStreamImpl(@Nullable AsyncClientSession clientSession, AsyncMongoCollection<GridFSFile> filesCollection, AsyncMongoCollection<Document> chunksCollection, BsonValue fileId, String filename, int chunkSizeBytes, @Nullable Document metadata, GridFSIndexCheck indexCheck) {
        this.clientSession = clientSession;
        this.filesCollection = Assertions.notNull("files collection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunks collection", chunksCollection);
        this.fileId = Assertions.notNull("File Id", fileId);
        this.filename = Assertions.notNull("filename", filename);
        this.chunkSizeBytes = chunkSizeBytes;
        this.metadata = metadata;
        this.indexCheck = indexCheck;
        this.chunkIndex = 0;
        this.bufferOffset = 0;
        this.buffer = new byte[chunkSizeBytes];
    }

    @Override
    public ObjectId getObjectId() {
        if (!this.fileId.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS upload stream");
        }
        return this.fileId.asObjectId().getValue();
    }

    @Override
    public BsonValue getId() {
        return this.fileId;
    }

    @Override
    public void abort(SingleResultCallback<Void> callback) {
        Assertions.notNull("callback", callback);
        final SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        if (!this.takeWritingLock(errHandlingCallback)) {
            return;
        }
        SingleResultCallback<DeleteResult> deleteCallback = new SingleResultCallback<DeleteResult>(){

            @Override
            public void onResult(DeleteResult result, Throwable t) {
                AsyncGridFSUploadStreamImpl.this.releaseWritingLock();
                errHandlingCallback.onResult(null, t);
            }
        };
        if (this.clientSession != null) {
            this.chunksCollection.deleteMany(this.clientSession, new Document("files_id", this.fileId), deleteCallback);
        } else {
            this.chunksCollection.deleteMany(new Document("files_id", this.fileId), deleteCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(final ByteBuffer src, SingleResultCallback<Integer> callback) {
        Assertions.notNull("src", src);
        Assertions.notNull("callback", callback);
        final SingleResultCallback<Integer> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        boolean checkIndexes = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            checkIndexes = !this.checkedIndexes;
        }
        if (checkIndexes) {
            if (!this.takeWritingLock(errHandlingCallback)) {
                return;
            }
            this.indexCheck.checkAndCreateIndex(new SingleResultCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(Void result, Throwable t) {
                    Object object = AsyncGridFSUploadStreamImpl.this.closeAndWritingLock;
                    synchronized (object) {
                        AsyncGridFSUploadStreamImpl.this.checkedIndexes = true;
                    }
                    AsyncGridFSUploadStreamImpl.this.releaseWritingLock();
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else {
                        AsyncGridFSUploadStreamImpl.this.write(src, errHandlingCallback);
                    }
                }
            });
        } else {
            this.write(src.remaining() == 0 ? -1 : src.remaining(), src, errHandlingCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(SingleResultCallback<Void> callback) {
        Assertions.notNull("callback", callback);
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        boolean alreadyClosed = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            alreadyClosed = this.closed;
            this.closed = true;
        }
        if (alreadyClosed) {
            errHandlingCallback.onResult(null, null);
            return;
        }
        if (!this.getAndSetWritingLock()) {
            this.callbackIsWritingException(errHandlingCallback);
            return;
        }
        this.writeChunk((result, t) -> {
            if (t != null) {
                this.releaseWritingLock();
                errHandlingCallback.onResult(null, t);
            } else {
                GridFSFile gridFSFile = new GridFSFile(this.fileId, this.filename, this.lengthInBytes, this.chunkSizeBytes, new Date(), this.metadata);
                SingleResultCallback<InsertOneResult> insertCallback = (insertOneResult, t1) -> {
                    this.buffer = null;
                    this.releaseWritingLock();
                    errHandlingCallback.onResult(null, t1);
                };
                if (this.clientSession != null) {
                    this.filesCollection.insertOne(this.clientSession, gridFSFile, insertCallback);
                } else {
                    this.filesCollection.insertOne(gridFSFile, insertCallback);
                }
            }
        });
    }

    private void write(int amount, ByteBuffer src, SingleResultCallback<Integer> callback) {
        if (!this.takeWritingLock(callback)) {
            return;
        }
        int len = src.remaining();
        if (len == 0) {
            this.releaseWritingLock();
            callback.onResult(amount, null);
            return;
        }
        int amountToCopy = len;
        if (amountToCopy > this.chunkSizeBytes - this.bufferOffset) {
            amountToCopy = this.chunkSizeBytes - this.bufferOffset;
        }
        src.get(this.buffer, this.bufferOffset, amountToCopy);
        this.bufferOffset += amountToCopy;
        this.lengthInBytes += (long)amountToCopy;
        if (this.bufferOffset == this.chunkSizeBytes) {
            this.writeChunk((result, t) -> {
                this.releaseWritingLock();
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    this.write(amount, src, callback);
                }
            });
        } else {
            this.releaseWritingLock();
            callback.onResult(amount, null);
        }
    }

    private <T> boolean takeWritingLock(SingleResultCallback<T> errHandlingCallback) {
        if (this.checkClosed()) {
            this.callbackClosedException(errHandlingCallback);
            return false;
        }
        if (!this.getAndSetWritingLock()) {
            this.releaseWritingLock();
            this.callbackIsWritingException(errHandlingCallback);
            return false;
        }
        return true;
    }

    private void writeChunk(SingleResultCallback<Void> callback) {
        if (this.bufferOffset > 0) {
            Document insertDocument = new Document("files_id", this.fileId).append("n", this.chunkIndex).append("data", this.getData());
            SingleResultCallback<InsertOneResult> insertCallback = (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    ++this.chunkIndex;
                    this.bufferOffset = 0;
                    callback.onResult(null, null);
                }
            };
            if (this.clientSession != null) {
                this.chunksCollection.insertOne(this.clientSession, insertDocument, insertCallback);
            } else {
                this.chunksCollection.insertOne(insertDocument, insertCallback);
            }
        } else {
            callback.onResult(null, null);
        }
    }

    private Binary getData() {
        if (this.bufferOffset < this.chunkSizeBytes) {
            byte[] sizedBuffer = new byte[this.bufferOffset];
            System.arraycopy(this.buffer, 0, sizedBuffer, 0, this.bufferOffset);
            this.buffer = sizedBuffer;
        }
        return new Binary(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkClosed() {
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAndSetWritingLock() {
        boolean gotLock = false;
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            if (!this.writing) {
                this.writing = true;
                gotLock = true;
            }
        }
        return gotLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWritingLock() {
        Object object = this.closeAndWritingLock;
        synchronized (object) {
            this.writing = false;
        }
    }

    private <T> void callbackClosedException(SingleResultCallback<T> callback) {
        callback.onResult(null, new MongoGridFSException("The AsyncOutputStream has been closed"));
    }

    private <T> void callbackIsWritingException(SingleResultCallback<T> callback) {
        callback.onResult(null, new MongoGridFSException("The AsyncOutputStream does not support concurrent writing."));
    }
}

