/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.internal.async.client.AsyncAggregateIterableImpl;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.internal.async.client.AsyncChangeStreamIterableImpl;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncDistinctIterable;
import com.mongodb.internal.async.client.AsyncDistinctIterableImpl;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.internal.async.client.AsyncFindIterableImpl;
import com.mongodb.internal.async.client.AsyncListIndexesIterable;
import com.mongodb.internal.async.client.AsyncListIndexesIterableImpl;
import com.mongodb.internal.async.client.AsyncMapReduceIterable;
import com.mongodb.internal.async.client.AsyncMapReduceIterableImpl;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.CountOptionsHelper;
import com.mongodb.internal.client.model.CountStrategy;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.CodecRegistryHelper;

class AsyncMongoCollectionImpl<TDocument>
implements AsyncMongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final UuidRepresentation uuidRepresentation;
    private final OperationExecutor executor;
    private final AsyncOperations<TDocument> operations;

    AsyncMongoCollectionImpl(MongoNamespace namespace, Class<TDocument> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, ReadConcern readConcern, UuidRepresentation uuidRepresentation, OperationExecutor executor) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.retryReads = retryReads;
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.executor = Assertions.notNull("executor", executor);
        this.operations = new AsyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public <NewTDocument> AsyncMongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> newDocumentClass) {
        return new AsyncMongoCollectionImpl<NewTDocument>(this.namespace, newDocumentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new AsyncMongoCollectionImpl<TDocument>(this.namespace, this.documentClass, CodecRegistryHelper.createRegistry(codecRegistry, this.uuidRepresentation), this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new AsyncMongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new AsyncMongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new AsyncMongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public void countDocuments(SingleResultCallback<Long> callback) {
        this.countDocuments(new BsonDocument(), callback);
    }

    @Override
    public void countDocuments(Bson filter, SingleResultCallback<Long> callback) {
        this.countDocuments(filter, new CountOptions(), callback);
    }

    @Override
    public void countDocuments(Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        this.executeCount(null, filter, options, CountStrategy.AGGREGATE, callback);
    }

    @Override
    public void countDocuments(AsyncClientSession clientSession, SingleResultCallback<Long> callback) {
        this.countDocuments(clientSession, new BsonDocument(), callback);
    }

    @Override
    public void countDocuments(AsyncClientSession clientSession, Bson filter, SingleResultCallback<Long> callback) {
        this.countDocuments(clientSession, filter, new CountOptions(), callback);
    }

    @Override
    public void countDocuments(AsyncClientSession clientSession, Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCount(clientSession, filter, options, CountStrategy.AGGREGATE, callback);
    }

    @Override
    public void estimatedDocumentCount(SingleResultCallback<Long> callback) {
        this.estimatedDocumentCount(new EstimatedDocumentCountOptions(), callback);
    }

    @Override
    public void estimatedDocumentCount(EstimatedDocumentCountOptions options, SingleResultCallback<Long> callback) {
        this.executeCount(null, new BsonDocument(), CountOptionsHelper.fromEstimatedDocumentCountOptions(options), CountStrategy.COMMAND, callback);
    }

    private void executeCount(@Nullable AsyncClientSession clientSession, Bson filter, CountOptions options, CountStrategy countStrategy, SingleResultCallback<Long> callback) {
        this.executor.execute(this.operations.count(filter, options, countStrategy), this.readPreference, this.readConcern, clientSession, callback);
    }

    @Override
    public <TResult> AsyncDistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> AsyncDistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return this.createDistinctIterable(null, fieldName, filter, resultClass);
    }

    @Override
    public <TResult> AsyncDistinctIterable<TResult> distinct(AsyncClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> AsyncDistinctIterable<TResult> distinct(AsyncClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createDistinctIterable(clientSession, fieldName, filter, resultClass);
    }

    private <TResult> AsyncDistinctIterable<TResult> createDistinctIterable(@Nullable AsyncClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new AsyncDistinctIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, fieldName, filter, this.retryReads);
    }

    @Override
    public AsyncFindIterable<TDocument> find() {
        return this.find(new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> AsyncFindIterable<TResult> find(Class<TResult> resultClass) {
        return this.find(new BsonDocument(), resultClass);
    }

    @Override
    public AsyncFindIterable<TDocument> find(Bson filter) {
        return this.find(filter, this.documentClass);
    }

    @Override
    public <TResult> AsyncFindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return this.createFindIterable(null, filter, resultClass);
    }

    @Override
    public AsyncFindIterable<TDocument> find(AsyncClientSession clientSession) {
        return this.find(clientSession, new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> AsyncFindIterable<TResult> find(AsyncClientSession clientSession, Class<TResult> resultClass) {
        return this.find(clientSession, new BsonDocument(), resultClass);
    }

    @Override
    public AsyncFindIterable<TDocument> find(AsyncClientSession clientSession, Bson filter) {
        return this.find(clientSession, filter, this.documentClass);
    }

    @Override
    public <TResult> AsyncFindIterable<TResult> find(AsyncClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createFindIterable(clientSession, filter, resultClass);
    }

    private <TResult> AsyncFindIterable<TResult> createFindIterable(@Nullable AsyncClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        return new AsyncFindIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, filter, this.retryReads);
    }

    @Override
    public AsyncAggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AsyncAggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AsyncAggregateIterable<TDocument> aggregate(AsyncClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> AsyncAggregateIterable<TResult> aggregate(AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createAggregateIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> AsyncAggregateIterable<TResult> createAggregateIterable(@Nullable AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AsyncAggregateIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline, AggregationLevel.COLLECTION, this.retryReads);
    }

    @Override
    public AsyncChangeStreamIterable<TDocument> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<TDocument> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<TDocument> watch(AsyncClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList());
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<TDocument> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> AsyncChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AsyncChangeStreamIterableImpl<TResult>(clientSession, this.namespace, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass, ChangeStreamLevel.COLLECTION, this.retryReads);
    }

    @Override
    public AsyncMapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> AsyncMapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return this.createMapReduceIterable(null, mapFunction, reduceFunction, resultClass);
    }

    @Override
    public AsyncMapReduceIterable<TDocument> mapReduce(AsyncClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> AsyncMapReduceIterable<TResult> mapReduce(AsyncClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createMapReduceIterable(clientSession, mapFunction, reduceFunction, resultClass);
    }

    private <TResult> AsyncMapReduceIterable<TResult> createMapReduceIterable(@Nullable AsyncClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new AsyncMapReduceIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        this.executeBulkWrite(null, requests, options, callback);
    }

    @Override
    public void bulkWrite(AsyncClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(clientSession, requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(AsyncClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeBulkWrite(clientSession, requests, options, callback);
    }

    private void executeBulkWrite(@Nullable AsyncClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        Assertions.notNull("requests", requests);
        this.executor.execute(this.operations.bulkWrite(requests, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void insertOne(TDocument document, SingleResultCallback<InsertOneResult> callback) {
        this.insertOne(document, new InsertOneOptions(), callback);
    }

    @Override
    public void insertOne(TDocument document, InsertOneOptions options, SingleResultCallback<InsertOneResult> callback) {
        this.executeInsertOne(null, document, options, callback);
    }

    @Override
    public void insertOne(AsyncClientSession clientSession, TDocument document, SingleResultCallback<InsertOneResult> callback) {
        this.insertOne(clientSession, document, new InsertOneOptions(), callback);
    }

    @Override
    public void insertOne(AsyncClientSession clientSession, TDocument document, InsertOneOptions options, SingleResultCallback<InsertOneResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeInsertOne(clientSession, document, options, callback);
    }

    private void executeInsertOne(@Nullable AsyncClientSession clientSession, TDocument document, InsertOneOptions options, SingleResultCallback<InsertOneResult> callback) {
        this.executeSingleWriteRequest(clientSession, this.operations.insertOne(document, options), WriteRequest.Type.INSERT, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.toInsertOneResult((BulkWriteResult)result), null);
            }
        });
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, SingleResultCallback<InsertManyResult> callback) {
        this.insertMany(documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, InsertManyOptions options, SingleResultCallback<InsertManyResult> callback) {
        this.executeInsertMany(null, documents, options, callback);
    }

    @Override
    public void insertMany(AsyncClientSession clientSession, List<? extends TDocument> documents, SingleResultCallback<InsertManyResult> callback) {
        this.insertMany(clientSession, documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(AsyncClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options, SingleResultCallback<InsertManyResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeInsertMany(clientSession, documents, options, callback);
    }

    private void executeInsertMany(@Nullable AsyncClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options, SingleResultCallback<InsertManyResult> callback) {
        this.executor.execute(this.operations.insertMany(documents, options), this.readConcern, clientSession, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.toInsertManyResult((BulkWriteResult)result), null);
            }
        });
    }

    @Override
    public void deleteOne(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteOne(filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteOne(Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        this.executeDelete(null, filter, options, false, callback);
    }

    @Override
    public void deleteOne(AsyncClientSession clientSession, Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteOne(clientSession, filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteOne(AsyncClientSession clientSession, Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, filter, options, false, callback);
    }

    @Override
    public void deleteMany(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteMany(filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteMany(Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        this.executeDelete(null, filter, options, true, callback);
    }

    @Override
    public void deleteMany(AsyncClientSession clientSession, Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteMany(clientSession, filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteMany(AsyncClientSession clientSession, Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, filter, options, true, callback);
    }

    private void executeDelete(@Nullable AsyncClientSession clientSession, Bson filter, DeleteOptions options, boolean multi, SingleResultCallback<DeleteResult> callback) {
        this.executeSingleWriteRequest(clientSession, multi ? this.operations.deleteMany(filter, options) : this.operations.deleteOne(filter, options), WriteRequest.Type.DELETE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else if (result.wasAcknowledged()) {
                callback.onResult(DeleteResult.acknowledged(result.getDeletedCount()), null);
            } else {
                callback.onResult(DeleteResult.unacknowledged(), null);
            }
        });
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, new ReplaceOptions(), callback);
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, ReplaceOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeReplaceOne(null, filter, replacement, options, callback);
    }

    @Override
    public void replaceOne(AsyncClientSession clientSession, Bson filter, TDocument replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(clientSession, filter, replacement, new ReplaceOptions(), callback);
    }

    @Override
    public void replaceOne(AsyncClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeReplaceOne(clientSession, filter, replacement, options, callback);
    }

    private void executeReplaceOne(@Nullable AsyncClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest(clientSession, this.operations.replaceOne(filter, replacement, options), WriteRequest.Type.REPLACE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.toUpdateResult((BulkWriteResult)result), null);
            }
        });
    }

    @Override
    public void updateOne(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, false, callback);
    }

    @Override
    public void updateOne(AsyncClientSession clientSession, Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(AsyncClientSession clientSession, Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUpdate(clientSession, filter, update, options, false, callback);
    }

    @Override
    public void updateOne(Bson filter, List<? extends Bson> update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Bson filter, List<? extends Bson> update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, false, callback);
    }

    @Override
    public void updateOne(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUpdate(clientSession, filter, update, options, false, callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, true, callback);
    }

    @Override
    public void updateMany(AsyncClientSession clientSession, Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(AsyncClientSession clientSession, Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUpdate(clientSession, filter, update, options, true, callback);
    }

    @Override
    public void updateMany(Bson filter, List<? extends Bson> update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Bson filter, List<? extends Bson> update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, true, callback);
    }

    @Override
    public void updateMany(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUpdate(clientSession, filter, update, options, true, callback);
    }

    private void executeUpdate(@Nullable AsyncClientSession clientSession, Bson filter, Bson update, UpdateOptions options, boolean multi, SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest(clientSession, multi ? this.operations.updateMany(filter, update, options) : this.operations.updateOne(filter, update, options), WriteRequest.Type.UPDATE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.toUpdateResult((BulkWriteResult)result), null);
            }
        });
    }

    private void executeUpdate(@Nullable AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options, boolean multi, SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest(clientSession, multi ? this.operations.updateMany(filter, update, options) : this.operations.updateOne(filter, update, options), WriteRequest.Type.UPDATE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.toUpdateResult((BulkWriteResult)result), null);
            }
        });
    }

    @Override
    public void findOneAndDelete(Bson filter, SingleResultCallback<TDocument> callback) {
        this.findOneAndDelete(filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndDelete(null, filter, options, callback);
    }

    @Override
    public void findOneAndDelete(AsyncClientSession clientSession, Bson filter, SingleResultCallback<TDocument> callback) {
        this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(AsyncClientSession clientSession, Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeFindOneAndDelete(clientSession, filter, options, callback);
    }

    private void executeFindOneAndDelete(@Nullable AsyncClientSession clientSession, Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndDelete(filter, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, SingleResultCallback<TDocument> callback) {
        this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndReplace(null, filter, replacement, options, callback);
    }

    @Override
    public void findOneAndReplace(AsyncClientSession clientSession, Bson filter, TDocument replacement, SingleResultCallback<TDocument> callback) {
        this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(AsyncClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeFindOneAndReplace(clientSession, filter, replacement, options, callback);
    }

    private void executeFindOneAndReplace(@Nullable AsyncClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndReplace(filter, replacement, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndUpdate(null, filter, update, options, callback);
    }

    @Override
    public void findOneAndUpdate(AsyncClientSession clientSession, Bson filter, Bson update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(AsyncClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeFindOneAndUpdate(clientSession, filter, update, options, callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, List<? extends Bson> update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndUpdate(null, filter, update, options, callback);
    }

    @Override
    public void findOneAndUpdate(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeFindOneAndUpdate(clientSession, filter, update, options, callback);
    }

    private void executeFindOneAndUpdate(@Nullable AsyncClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndUpdate(filter, update, options), this.readConcern, clientSession, callback);
    }

    private void executeFindOneAndUpdate(@Nullable AsyncClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndUpdate(filter, update, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(@Nullable AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropCollection(), this.readConcern, clientSession, callback);
    }

    @Override
    public void createIndex(Bson key, SingleResultCallback<String> callback) {
        this.createIndex(key, new IndexOptions(), callback);
    }

    @Override
    public void createIndex(Bson key, IndexOptions indexOptions, SingleResultCallback<String> callback) {
        this.createIndexes(Collections.singletonList(new IndexModel(key, indexOptions)), (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((String)result.get(0), null);
            }
        });
    }

    @Override
    public void createIndex(AsyncClientSession clientSession, Bson key, SingleResultCallback<String> callback) {
        this.createIndex(clientSession, key, new IndexOptions(), callback);
    }

    @Override
    public void createIndex(AsyncClientSession clientSession, Bson key, IndexOptions indexOptions, SingleResultCallback<String> callback) {
        this.createIndexes(clientSession, Collections.singletonList(new IndexModel(key, indexOptions)), (List<String> result, Throwable t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((String)result.get(0), null);
            }
        });
    }

    @Override
    public void createIndexes(List<IndexModel> indexes, SingleResultCallback<List<String>> callback) {
        this.createIndexes(indexes, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions, SingleResultCallback<List<String>> callback) {
        this.executeCreateIndexes(null, indexes, createIndexOptions, callback);
    }

    @Override
    public void createIndexes(AsyncClientSession clientSession, List<IndexModel> indexes, SingleResultCallback<List<String>> callback) {
        this.createIndexes(clientSession, indexes, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndexes(AsyncClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions, SingleResultCallback<List<String>> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateIndexes(clientSession, indexes, createIndexOptions, callback);
    }

    private void executeCreateIndexes(@Nullable AsyncClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions, SingleResultCallback<List<String>> callback) {
        this.executor.execute(this.operations.createIndexes(indexes, createIndexOptions), this.readConcern, clientSession, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(IndexHelper.getIndexNames(indexes, this.codecRegistry), null);
            }
        });
    }

    @Override
    public AsyncListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> AsyncListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return this.createListIndexesIterable(null, resultClass);
    }

    @Override
    public AsyncListIndexesIterable<Document> listIndexes(AsyncClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> AsyncListIndexesIterable<TResult> listIndexes(AsyncClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListIndexesIterable(clientSession, resultClass);
    }

    private <TResult> AsyncListIndexesIterable<TResult> createListIndexesIterable(@Nullable AsyncClientSession clientSession, Class<TResult> resultClass) {
        return new AsyncListIndexesIterableImpl<TResult>(clientSession, this.namespace, resultClass, this.codecRegistry, this.readPreference, this.executor, this.retryReads);
    }

    @Override
    public void dropIndex(String indexName, SingleResultCallback<Void> callback) {
        this.dropIndex(indexName, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executeDropIndex(null, indexName, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(Bson keys, SingleResultCallback<Void> callback) {
        this.dropIndex(keys, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executeDropIndex(null, keys, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(AsyncClientSession clientSession, String indexName, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, indexName, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(AsyncClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDropIndex(clientSession, indexName, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(AsyncClientSession clientSession, Bson keys, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, keys, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(AsyncClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDropIndex(clientSession, keys, dropIndexOptions, callback);
    }

    @Override
    public void dropIndexes(SingleResultCallback<Void> callback) {
        this.dropIndexes(new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.dropIndex("*", dropIndexOptions, callback);
    }

    @Override
    public void dropIndexes(AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        this.dropIndexes(clientSession, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndexes(AsyncClientSession clientSession, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, "*", dropIndexOptions, callback);
    }

    private void executeDropIndex(@Nullable AsyncClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropIndex(keys, dropIndexOptions), this.readConcern, clientSession, callback);
    }

    private void executeDropIndex(@Nullable AsyncClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropIndex(indexName, dropIndexOptions), this.readConcern, clientSession, callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executeRenameCollection(null, newCollectionNamespace, options, callback);
    }

    @Override
    public void renameCollection(AsyncClientSession clientSession, MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(AsyncClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRenameCollection(clientSession, newCollectionNamespace, options, callback);
    }

    private void executeRenameCollection(@Nullable AsyncClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.renameCollection(newCollectionNamespace, options), this.readConcern, clientSession, callback);
    }

    private void executeSingleWriteRequest(@Nullable AsyncClientSession clientSession, AsyncWriteOperation<BulkWriteResult> writeOperation, WriteRequest.Type type, SingleResultCallback<BulkWriteResult> callback) {
        this.executor.execute(writeOperation, this.readConcern, clientSession, (result, t) -> {
            if (t instanceof MongoBulkWriteException) {
                MongoBulkWriteException e = (MongoBulkWriteException)t;
                MongoServerException exception = e.getWriteErrors().isEmpty() ? new MongoWriteConcernException(e.getWriteConcernError(), this.translateBulkWriteResult(type, e.getWriteResult()), e.getServerAddress()) : new MongoWriteException(new WriteError(e.getWriteErrors().get(0)), e.getServerAddress());
                for (String errorLabel : e.getErrorLabels()) {
                    exception.addLabel(errorLabel);
                }
                callback.onResult(null, exception);
            } else {
                callback.onResult((BulkWriteResult)result, t);
            }
        });
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest.Type type, BulkWriteResult writeResult) {
        switch (type) {
            case INSERT: {
                return WriteConcernResult.acknowledged(writeResult.getInsertedCount(), false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged(writeResult.getDeletedCount(), false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged(writeResult.getMatchedCount() + writeResult.getUpserts().size(), writeResult.getMatchedCount() > 0, writeResult.getUpserts().isEmpty() ? null : writeResult.getUpserts().get(0).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + (Object)((Object)type));
    }

    private InsertOneResult toInsertOneResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            BsonValue insertedId = result.getInserts().isEmpty() ? null : result.getInserts().get(0).getId();
            return InsertOneResult.acknowledged(insertedId);
        }
        return InsertOneResult.unacknowledged();
    }

    private InsertManyResult toInsertManyResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            return InsertManyResult.acknowledged(result.getInserts().stream().collect(HashMap::new, (m, v) -> m.put(v.getIndex(), v.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : result.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(result.getMatchedCount(), Long.valueOf(result.getModifiedCount()), upsertedId);
        }
        return UpdateResult.unacknowledged();
    }
}

