/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bukkit.event.Event;

@Name(value="Mongo Value")
@Description(value={"This expression allows you to retrieve and modify certain values of a document. If you define an already existing entry, it will be replaced. Lists are supported."})
@Examples(value={"set {_document} to first document where \"points\" is \"10\" in {_collection}set {test::%value \"test\" of {_document}%} to trueloop list \"example\" of {_document}:\tbroadcast \"%loop-value%\"set list \"example\" of {_document} to 10, 54 and 203add 41 to list \"example\" of {_document}save {_document} in collection named \"example\" from database named \"mongosk\" with client named \"default\""})
@Since(value="1.0.0")
public class ExprValue
extends SimpleExpression<Object> {
    private Expression<String> exprValue;
    private Expression<Document> exprDocument;
    private int parseMark;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprValue = exprs[0];
        this.exprDocument = exprs[1];
        this.parseMark = parseResult.mark;
        return true;
    }

    protected Object[] get(Event e) {
        String value = (String)this.exprValue.getSingle(e);
        Document document = (Document)this.exprDocument.getSingle(e);
        if (value == null || document == null) {
            return null;
        }
        if (this.parseMark == 1) {
            return new Object[]{document.get(value)};
        }
        List<Object> list = document.getList(value, Object.class);
        return list != null ? list.toArray() : null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET || this.parseMark == 1 && (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD)) {
            return null;
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{this.parseMark == 1 ? Object.class : Object[].class});
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ArrayList deltaList;
        String value = (String)this.exprValue.getSingle(e);
        Document document = (Document)this.exprDocument.getSingle(e);
        ArrayList arrayList = deltaList = delta != null ? Arrays.asList(delta) : new ArrayList();
        if (value == null || document == null) {
            return;
        }
        switch (mode) {
            case SET: {
                document.put(value, deltaList.size() == 1 ? delta[0] : deltaList);
                break;
            }
            case DELETE: {
                document.put(value, (Object)null);
                break;
            }
            case ADD: {
                List<Object> addList = document.getList(value, Object.class);
                if (addList == null) {
                    document.put(value, (Object)deltaList);
                    return;
                }
                addList.addAll(deltaList);
                break;
            }
            case REMOVE: {
                List<Object> removeList = document.getList(value, Object.class);
                if (removeList == null) {
                    return;
                }
                deltaList.forEach(removeList::remove);
                break;
            }
        }
    }

    public boolean isSingle() {
        return this.parseMark == 1;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event e, boolean debug) {
        return "mongo value " + this.exprValue.toString(e, debug) + " of " + this.exprDocument.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprValue.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[mongo[db]] (1\u00a6value|2\u00a6list) %string% (of|from) %mongodocument%"});
    }
}

