/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.mongodb.client.MongoDatabase;

@Name(value="Mongo Database Name")
@Description(value={"This expression allows you to retrieve the name of a Mongo database."})
@Examples(value={"set {_database} to database named \"mongosk\" with client named \"default\"send name of {_database}"})
@Since(value="1.0.0")
public class ExprDatabaseName
extends SimplePropertyExpression<MongoDatabase, String> {
    public String convert(MongoDatabase mongoDatabase) {
        return mongoDatabase.getName();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "mongo name";
    }

    static {
        ExprDatabaseName.register(ExprDatabaseName.class, String.class, (String)"[mongo[db]] name", (String)"mongodatabases");
    }
}

