/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bukkit.event.Event;

@Name(value="Mongo Database")
@Description(value={"This expression allows you to retrieve a Mongo database from a specific client."})
@Examples(value={"set {_client} to client named \"default\"set {_database} to database named \"mongosk\" with {_client}send \"The name of this database is %{_database}'s name%.\""})
@Since(value="1.0.0")
public class ExprDatabase
extends SimpleExpression<MongoDatabase> {
    private Expression<String> exprName;
    private Expression<MongoClient> exprClient;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprClient = exprs[1];
        return true;
    }

    protected MongoDatabase[] get(Event e) {
        String name = (String)this.exprName.getSingle(e);
        MongoClient client = (MongoClient)this.exprClient.getSingle(e);
        if (name == null || client == null) {
            return null;
        }
        return new MongoDatabase[]{client.getDatabase(name)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MongoDatabase> getReturnType() {
        return MongoDatabase.class;
    }

    public String toString(Event e, boolean debug) {
        return "mongo database named " + this.exprName.toString(e, debug) + " with " + this.exprClient.toString();
    }

    static {
        Skript.registerExpression(ExprDatabase.class, MongoDatabase.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[mongo[db]] database [(named|with name|called)] %string% (of|with) %mongoclient%"});
    }
}

