/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.mongodb.client.MongoCollection;
import fr.romitou.mongosk.skript.expressions.ExprDatabaseName;

@Name(value="Mongo Collection Name")
@Description(value={"This expression allows you to retrieve the name of a Mongo collection."})
@Examples(value={"set {_collection} to collection named \"example\" from database named \"mongosk\" with client named \"default\"send name of {_collection}"})
@Since(value="1.0.0")
public class ExprCollectionName
extends SimplePropertyExpression<MongoCollection, String> {
    public String convert(MongoCollection mongoCollection) {
        return mongoCollection.getNamespace().getCollectionName();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "mongo name";
    }

    static {
        ExprCollectionName.register(ExprDatabaseName.class, String.class, (String)"[mongo[db]] name", (String)"mongocollections");
    }
}

