/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.internal.async.client.AsyncAggregateIterableImpl;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.internal.async.client.AsyncChangeStreamIterableImpl;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncListCollectionsIterable;
import com.mongodb.internal.async.client.AsyncListCollectionsIterableImpl;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.AsyncMongoCollectionImpl;
import com.mongodb.internal.async.client.AsyncMongoDatabase;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CreateCollectionOperation;
import com.mongodb.internal.operation.CreateViewOperation;
import com.mongodb.internal.operation.DropDatabaseOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.CodecRegistryHelper;

class AsyncMongoDatabaseImpl
implements AsyncMongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final UuidRepresentation uuidRepresentation;
    private final OperationExecutor executor;

    AsyncMongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, ReadConcern readConcern, UuidRepresentation uuidRepresentation, OperationExecutor executor) {
        MongoNamespace.checkDatabaseNameValidity(name);
        this.name = Assertions.notNull("name", name);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.retryReads = retryReads;
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", executor);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public AsyncMongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new AsyncMongoDatabaseImpl(this.name, CodecRegistryHelper.createRegistry(codecRegistry, this.uuidRepresentation), this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoDatabase withReadPreference(ReadPreference readPreference) {
        return new AsyncMongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new AsyncMongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoDatabase withReadConcern(ReadConcern readConcern) {
        return new AsyncMongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public AsyncMongoIterable<String> listCollectionNames() {
        return this.createListCollectionNamesIterable(null);
    }

    @Override
    public AsyncMongoIterable<String> listCollectionNames(AsyncClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionNamesIterable(clientSession);
    }

    private AsyncMongoIterable<String> createListCollectionNamesIterable(@Nullable AsyncClientSession clientSession) {
        return this.createListCollectionsIterable(clientSession, BsonDocument.class, true).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }

    @Override
    public AsyncListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> AsyncListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return this.createListCollectionsIterable(null, resultClass, false);
    }

    @Override
    public AsyncListCollectionsIterable<Document> listCollections(AsyncClientSession clientSession) {
        return this.listCollections(clientSession, Document.class);
    }

    @Override
    public <TResult> AsyncListCollectionsIterable<TResult> listCollections(AsyncClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionsIterable(clientSession, resultClass, false);
    }

    private <TResult> AsyncListCollectionsIterable<TResult> createListCollectionsIterable(@Nullable AsyncClientSession clientSession, Class<TResult> resultClass, boolean collectionNamesOnly) {
        return new AsyncListCollectionsIterableImpl<TResult>(clientSession, this.name, collectionNamesOnly, resultClass, this.codecRegistry, ReadPreference.primary(), this.executor, this.retryReads);
    }

    @Override
    public AsyncMongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> AsyncMongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new AsyncMongoCollectionImpl<TDocument>(new MongoNamespace(this.name, collectionName), documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.executor);
    }

    @Override
    public void runCommand(Bson command, SingleResultCallback<Document> callback) {
        this.runCommand(command, Document.class, callback);
    }

    @Override
    public void runCommand(Bson command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.runCommand(command, readPreference, Document.class, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.runCommand(command, ReadPreference.primary(), resultClass, callback);
    }

    @Override
    public <TResult> void runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.executeCommand(null, command, readPreference, resultClass, callback);
    }

    @Override
    public void runCommand(AsyncClientSession clientSession, Bson command, SingleResultCallback<Document> callback) {
        this.runCommand(clientSession, command, Document.class, callback);
    }

    @Override
    public void runCommand(AsyncClientSession clientSession, Bson command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.runCommand(clientSession, command, readPreference, Document.class, callback);
    }

    @Override
    public <TResult> void runCommand(AsyncClientSession clientSession, Bson command, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        this.runCommand(clientSession, command, ReadPreference.primary(), resultClass, callback);
    }

    @Override
    public <TResult> void runCommand(AsyncClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCommand(clientSession, command, readPreference, resultClass, callback);
    }

    private <TResult> void executeCommand(@Nullable AsyncClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass, SingleResultCallback<TResult> callback) {
        Assertions.notNull("command", command);
        Assertions.notNull("readPreference", readPreference);
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            throw new MongoClientException("Read preference in a transaction must be primary");
        }
        this.executor.execute(new CommandReadOperation<TResult>(this.getName(), this.toBsonDocument(command), this.codecRegistry.get(resultClass)), readPreference, this.readConcern, clientSession, callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(@Nullable AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        this.executor.execute(new DropDatabaseOperation(this.name, this.writeConcern), this.readConcern, clientSession, callback);
    }

    @Override
    public void createCollection(String collectionName, SingleResultCallback<Void> callback) {
        this.executeCreateCollection(null, collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, SingleResultCallback<Void> callback) {
        this.executeCreateCollection(null, collectionName, createCollectionOptions, callback);
    }

    @Override
    public void createCollection(AsyncClientSession clientSession, String collectionName, SingleResultCallback<Void> callback) {
        this.createCollection(clientSession, collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(AsyncClientSession clientSession, String collectionName, CreateCollectionOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateCollection(clientSession, collectionName, options, callback);
    }

    private void executeCreateCollection(@Nullable AsyncClientSession clientSession, String collectionName, CreateCollectionOptions options, SingleResultCallback<Void> callback) {
        ValidationOptions validationOptions;
        Bson validator;
        CreateCollectionOperation operation = new CreateCollectionOperation(this.name, collectionName, this.writeConcern).capped(options.isCapped()).sizeInBytes(options.getSizeInBytes()).maxDocuments(options.getMaxDocuments()).storageEngineOptions(this.toBsonDocument(options.getStorageEngineOptions())).collation(options.getCollation());
        IndexOptionDefaults indexOptionDefaults = options.getIndexOptionDefaults();
        Bson storageEngine = indexOptionDefaults.getStorageEngine();
        if (storageEngine != null) {
            operation.indexOptionDefaults(new BsonDocument("storageEngine", this.toBsonDocument(storageEngine)));
        }
        if ((validator = (validationOptions = options.getValidationOptions()).getValidator()) != null) {
            operation.validator(this.toBsonDocument(validator));
        }
        if (validationOptions.getValidationLevel() != null) {
            operation.validationLevel(validationOptions.getValidationLevel());
        }
        if (validationOptions.getValidationAction() != null) {
            operation.validationAction(validationOptions.getValidationAction());
        }
        this.executor.execute(operation, this.readConcern, clientSession, callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, SingleResultCallback<Void> callback) {
        this.createView(viewName, viewOn, pipeline, new CreateViewOptions(), callback);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        this.executeCreateView(null, viewName, viewOn, pipeline, createViewOptions, callback);
    }

    @Override
    public void createView(AsyncClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, SingleResultCallback<Void> callback) {
        this.createView(clientSession, viewName, viewOn, pipeline, new CreateViewOptions(), callback);
    }

    @Override
    public void createView(AsyncClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateView(clientSession, viewName, viewOn, pipeline, createViewOptions, callback);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public AsyncAggregateIterable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncAggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AsyncAggregateIterable<Document> aggregate(AsyncClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AsyncAggregateIterable<TResult> aggregate(AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(Assertions.notNull("clientSession", clientSession), pipeline, resultClass);
    }

    private <TResult> AsyncAggregateIterable<TResult> createAggregateIterable(@Nullable AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AsyncAggregateIterableImpl<Document, TResult>(clientSession, this.name, Document.class, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline, AggregationLevel.DATABASE, this.retryReads);
    }

    private <TResult> AsyncChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable AsyncClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AsyncChangeStreamIterableImpl<TResult>(clientSession, this.name, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass, ChangeStreamLevel.DATABASE, this.retryReads);
    }

    private void executeCreateView(@Nullable AsyncClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull("createViewOptions", createViewOptions);
        this.executor.execute(new CreateViewOperation(this.name, viewName, viewOn, this.createBsonDocumentList(pipeline), this.writeConcern).collation(createViewOptions.getCollation()), this.readConcern, clientSession, callback);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        Assertions.notNull("pipeline", pipeline);
        ArrayList<BsonDocument> bsonDocumentPipeline = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            bsonDocumentPipeline.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return bsonDocumentPipeline;
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

