/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncMapReduceIterable;
import com.mongodb.internal.async.client.AsyncMongoIterableImpl;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.async.client.WriteOperationThenCursorReadOperation;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AsyncMapReduceIterableImpl<TDocument, TResult>
extends AsyncMongoIterableImpl<TResult>
implements AsyncMapReduceIterable<TResult> {
    private final AsyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TResult> resultClass;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    AsyncMapReduceIterableImpl(@Nullable AsyncClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, String mapFunction, String reduceFunction) {
        super(clientSession, executor, readConcern, readPreference, false);
        this.operations = new AsyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, false, false);
        this.namespace = Assertions.notNull("namespace", namespace);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
    }

    @Override
    public AsyncMapReduceIterable<TResult> collectionName(String collectionName) {
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> finalizeFunction(@Nullable String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> scope(@Nullable Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> sort(@Nullable Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> databaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AsyncMapReduceIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        Assertions.notNull("callback", callback);
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        this.getExecutor().execute(this.createMapReduceToCollectionOperation(), this.getReadConcern(), callback);
    }

    @Override
    ReadPreference getReadPreference() {
        if (this.inline) {
            return super.getReadPreference();
        }
        return ReadPreference.primary();
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        if (this.inline) {
            return this.createMapReduceInlineOperation();
        }
        return new WriteOperationThenCursorReadOperation(this.createMapReduceToCollectionOperation(), this.createFindOperation());
    }

    private WrappedMapReduceReadOperation<TResult> createMapReduceInlineOperation() {
        return new WrappedMapReduceReadOperation<TResult>(this.operations.mapReduce(this.mapFunction, this.reduceFunction, this.finalizeFunction, this.resultClass, this.filter, this.limit, this.maxTimeMS, this.jsMode, this.scope, this.sort, this.verbose, this.collation));
    }

    private WrappedMapReduceWriteOperation createMapReduceToCollectionOperation() {
        return new WrappedMapReduceWriteOperation(this.operations.mapReduceToCollection(this.databaseName, this.collectionName, this.mapFunction, this.reduceFunction, this.finalizeFunction, this.filter, this.limit, this.maxTimeMS, this.jsMode, this.scope, this.sort, this.verbose, this.action, this.nonAtomic, this.sharded, this.bypassDocumentValidation, this.collation));
    }

    private AsyncReadOperation<AsyncBatchCursor<TResult>> createFindOperation() {
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        FindOptions findOptions = new FindOptions().collation(this.collation);
        Integer batchSize = this.getBatchSize();
        if (batchSize != null) {
            findOptions.batchSize(batchSize);
        }
        return this.operations.find(new MongoNamespace(dbName, this.collectionName), new BsonDocument(), this.resultClass, findOptions);
    }

    static class WrappedMapReduceWriteOperation
    implements AsyncWriteOperation<Void> {
        private final AsyncWriteOperation<MapReduceStatistics> operation;

        AsyncWriteOperation<MapReduceStatistics> getOperation() {
            return this.operation;
        }

        WrappedMapReduceWriteOperation(AsyncWriteOperation<MapReduceStatistics> operation) {
            this.operation = operation;
        }

        @Override
        public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
            this.operation.executeAsync(binding, new SingleResultCallback<MapReduceStatistics>(){

                @Override
                public void onResult(MapReduceStatistics result, Throwable t) {
                    callback.onResult(null, t);
                }
            });
        }
    }

    static class WrappedMapReduceReadOperation<TResult>
    implements AsyncReadOperation<AsyncBatchCursor<TResult>> {
        private final AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> operation;

        AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> getOperation() {
            return this.operation;
        }

        WrappedMapReduceReadOperation(AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> operation) {
            this.operation = operation;
        }

        @Override
        public void executeAsync(AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
            this.operation.executeAsync(binding, new SingleResultCallback<MapReduceAsyncBatchCursor<TResult>>(){

                @Override
                public void onResult(MapReduceAsyncBatchCursor<TResult> batchCursor, Throwable t) {
                    callback.onResult(batchCursor, t);
                }
            });
        }
    }
}

