/*
 * Decompiled with CFR 0.152.
 */
package fr.romitou.mongosk.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.mongodb.client.MongoCollection;

@Name(value="Mongo Collection Database Name")
@Description(value={"This expression allows you to retrieve the name of the database of a Mongo collection."})
@Examples(value={"set {_collection} to collection named \"example\" from database named \"mongosk\" with client named \"default\"send {_collection}'s database name"})
@Since(value="1.0.0")
public class ExprCollectionDatabaseName
extends SimplePropertyExpression<MongoCollection, String> {
    public String convert(MongoCollection mongoCollection) {
        return mongoCollection.getNamespace().getDatabaseName();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "database name";
    }

    static {
        ExprCollectionDatabaseName.register(ExprCollectionDatabaseName.class, String.class, (String)"[mongo[db]] database name", (String)"mongocollections");
    }
}

