/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Laser {
    private final int duration;
    private final int distanceSquared;
    private final Location start;
    private final Location end;
    private final Object createGuardianPacket;
    private final Object createSquidPacket;
    private final Object destroyPacket;
    private final int squid;
    private final int guardian;
    private BukkitRunnable run;

    public Laser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.distanceSquared = distance * distance;
        this.createSquidPacket = Packets.createPacketSquidSpawn(end);
        this.squid = (Integer)Packets.getField(Packets.packetSpawn, "a", this.createSquidPacket);
        this.createGuardianPacket = Packets.createPacketGuardianSpawn(start, this.squid);
        this.guardian = (Integer)Packets.getField(Packets.packetSpawn, "a", this.createGuardianPacket);
        this.destroyPacket = Packets.createPacketRemoveEntities(this.squid, this.guardian);
    }

    public void start(Plugin plugin) {
        Validate.isTrue((this.run == null ? 1 : 0) != 0, (String)"Task already started");
        this.run = new BukkitRunnable(){
            int time;
            HashSet<Player> show;
            {
                this.time = Laser.this.duration;
                this.show = new HashSet();
            }

            public void run() {
                try {
                    if (this.time == 0) {
                        this.cancel();
                        return;
                    }
                    for (Player p : Laser.this.start.getWorld().getPlayers()) {
                        if (Laser.this.isCloseEnough(p.getLocation())) {
                            if (this.show.contains(p)) continue;
                            Laser.this.sendStartPackets(p);
                            this.show.add(p);
                            continue;
                        }
                        if (!this.show.contains(p)) continue;
                        Packets.sendPacket(p, Laser.this.destroyPacket);
                        this.show.remove(p);
                    }
                    if (this.time != -1) {
                        --this.time;
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                try {
                    for (Player p : this.show) {
                        Packets.sendPacket(p, Laser.this.destroyPacket);
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                Laser.this.run = null;
            }
        };
        this.run.runTaskTimer(plugin, 0L, 20L);
    }

    public void stop() {
        Validate.isTrue((this.run != null ? 1 : 0) != 0, (String)"Task not started");
        this.run.cancel();
    }

    public boolean isStarted() {
        return this.run != null;
    }

    private void sendStartPackets(Player p) throws ReflectiveOperationException {
        Packets.sendPacket(p, this.createSquidPacket);
        Packets.sendPacket(p, this.createGuardianPacket);
    }

    private boolean isCloseEnough(Location location) {
        return this.start.distanceSquared(location) <= (double)this.distanceSquared || this.end.distanceSquared(location) <= (double)this.distanceSquared;
    }

    private static class Packets {
        private static int lastIssuedEID = 2000000000;
        private static int version = Integer.parseInt(Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3].substring(1).split("_")[1]);
        private static String npack = "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + ".";
        private static String cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
        private static Object fakeSquid;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Class<?> packetSpawn;
        private static String watcherSet1;
        private static String watcherSet2;
        private static String watcherSet3;
        private static int squidID;
        private static int guardianID;

        private Packets() {
        }

        static int generateEID() {
            return lastIssuedEID++;
        }

        public static void sendPacket(Player p, Object packet) throws ReflectiveOperationException {
            Object entityPlayer = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
            Object playerConnection = entityPlayer.getClass().getDeclaredField("playerConnection").get(entityPlayer);
            playerConnection.getClass().getDeclaredMethod("sendPacket", Class.forName(npack + "Packet")).invoke(playerConnection, packet);
        }

        public static Object createPacketSquidSpawn(Location location) throws ReflectiveOperationException {
            Object packet = packetSpawn.newInstance();
            Packets.setField(packet, "a", Packets.generateEID());
            Packets.setField(packet, "b", UUID.randomUUID());
            Packets.setField(packet, "c", squidID);
            Packets.setField(packet, "d", location.getX());
            Packets.setField(packet, "e", location.getY());
            Packets.setField(packet, "f", location.getZ());
            Packets.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            Object nentity = fakeSquid.getClass().getDeclaredMethod("getHandle", new Class[0]).invoke(fakeSquid, new Object[0]);
            Object watcher = Class.forName(npack + "Entity").getDeclaredMethod("getDataWatcher", new Class[0]).invoke(nentity, new Object[0]);
            watcherSet.invoke(watcher, Packets.getField(Class.forName(npack + "Entity"), watcherSet1, null), (byte)32);
            Packets.setField(packet, "m", watcher);
            return packet;
        }

        public static Object createPacketGuardianSpawn(Location location, int entityId) throws ReflectiveOperationException {
            Object packet = packetSpawn.newInstance();
            Packets.setField(packet, "a", Packets.generateEID());
            Packets.setField(packet, "b", UUID.randomUUID());
            Packets.setField(packet, "c", guardianID);
            Packets.setField(packet, "d", location.getX());
            Packets.setField(packet, "e", location.getY());
            Packets.setField(packet, "f", location.getZ());
            Packets.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            Object nentity = fakeSquid.getClass().getDeclaredMethod("getHandle", new Class[0]).invoke(fakeSquid, new Object[0]);
            Object watcher = Class.forName(npack + "Entity").getDeclaredMethod("getDataWatcher", new Class[0]).invoke(nentity, new Object[0]);
            watcherSet.invoke(watcher, Packets.getField(Class.forName(npack + "Entity"), watcherSet1, null), (byte)32);
            try {
                watcherSet.invoke(watcher, Packets.getField(Class.forName(npack + "EntityGuardian"), watcherSet2, null), false);
            }
            catch (InvocationTargetException ex) {
                watcherRegister.invoke(watcher, Packets.getField(Class.forName(npack + "EntityGuardian"), watcherSet2, null), false);
            }
            try {
                watcherSet.invoke(watcher, Packets.getField(Class.forName(npack + "EntityGuardian"), watcherSet3, null), entityId);
            }
            catch (InvocationTargetException ex) {
                watcherRegister.invoke(watcher, Packets.getField(Class.forName(npack + "EntityGuardian"), watcherSet3, null), entityId);
            }
            Packets.setField(packet, "m", watcher);
            return packet;
        }

        public static Object createPacketRemoveEntities(int squidId, int guardianId) throws ReflectiveOperationException {
            Object packet = Class.forName(npack + "PacketPlayOutEntityDestroy").newInstance();
            Packets.setField(packet, "a", new int[]{squidId, guardianId});
            return packet;
        }

        private static Method getMethod(Class<?> clazz, String name) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            return null;
        }

        private static void setField(Object instance, String name, Object value) throws ReflectiveOperationException {
            Validate.notNull((Object)instance);
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }

        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        static {
            try {
                Object[] objectArray;
                if (version < 13) {
                    watcherSet1 = "Z";
                    watcherSet2 = "bA";
                    watcherSet3 = "bB";
                    squidID = 94;
                    guardianID = 68;
                } else if (version == 13) {
                    watcherSet1 = "ac";
                    watcherSet2 = "bF";
                    watcherSet3 = "bG";
                    squidID = 70;
                    guardianID = 28;
                } else if (version > 13) {
                    watcherSet1 = "W";
                    watcherSet2 = "b";
                    watcherSet3 = "bD";
                    squidID = 73;
                    guardianID = 30;
                }
                Object world = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                if (version < 14) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = world;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = Class.forName(npack + "EntityTypes").getDeclaredField("SQUID").get(null);
                    objectArray = objectArray3;
                    objectArray3[1] = world;
                }
                Object[] entityConstructorParams = objectArray;
                fakeSquid = Class.forName(cpack + "entity.CraftSquid").getDeclaredConstructors()[0].newInstance(null, Class.forName(npack + "EntitySquid").getDeclaredConstructors()[0].newInstance(entityConstructorParams));
                watcherSet = Packets.getMethod(Class.forName(npack + "DataWatcher"), "set");
                watcherRegister = Packets.getMethod(Class.forName(npack + "DataWatcher"), "register");
                packetSpawn = Class.forName(npack + "PacketPlayOutSpawnEntityLiving");
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }
}

