/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.utils;

import com.moderocky.misk.utils.pathfinder.Navigation;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.EntityAnimal;
import net.minecraft.server.v1_14_R1.EntityCreature;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityUtils {
    public static void leash(Entity entity, Player player) {
        EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
        insentient.setLeashHolder(((CraftEntity)player).getHandle(), true);
    }

    public static void leash(Entity entity, Entity holder) {
        if (holder instanceof Player) {
            EntityUtils.leash(entity, (Player)holder);
        } else {
            EntityInsentient insentient = (EntityInsentient)((CraftEntity)entity).getHandle();
            insentient.setLeashHolder(((CraftEntity)holder).getHandle(), false);
        }
    }

    public static void moveToPosition(Entity entity, Location location, Double speed) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if ((EntityInsentient)nmsEntity != null) {
            EntityInsentient entityInsentient = (EntityInsentient)nmsEntity;
            Navigation.moveToPosition(entityInsentient, location, speed);
        } else {
            Navigation.moveToPosition(nmsEntity, location, speed);
        }
    }

    public static void moveToPosition(Entity entity, Entity target, Double speed) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        net.minecraft.server.v1_14_R1.Entity nmsTarget = ((CraftEntity)target).getHandle();
        if ((EntityInsentient)nmsEntity != null) {
            EntityInsentient entityInsentient = (EntityInsentient)nmsEntity;
            Navigation.moveToPosition((net.minecraft.server.v1_14_R1.Entity)entityInsentient, nmsTarget, speed);
        } else {
            Navigation.moveToPosition(nmsEntity, nmsTarget, speed);
        }
    }

    public static void stopPathfinding(Entity entity) {
        Navigation.stopPathfinding(((CraftEntity)entity).getHandle());
    }

    public static void setHitBox(Entity entity, Number width, Number height) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Double d0 = (Double)width / 2.0 * -1.0;
        Double d1 = 0.0;
        Double d2 = (Double)width / 2.0 * -1.0;
        Double d3 = (Double)width / 2.0;
        Double d4 = (Double)height;
        Double d5 = (Double)width / 2.0;
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        axisAlignedBB.a(d0.doubleValue(), d1.doubleValue(), d2.doubleValue(), d3.doubleValue(), d4.doubleValue(), d5.doubleValue());
        nmsEntity.a(axisAlignedBB);
    }

    public static void growHitBox(Entity entity, Number number) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Double d0 = (Double)number;
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        axisAlignedBB.grow(d0.doubleValue());
        nmsEntity.a(axisAlignedBB);
    }

    public static void shrinkHitBox(Entity entity, Number number) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Double d0 = (Double)number;
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        axisAlignedBB.shrink(d0.doubleValue());
        nmsEntity.a(axisAlignedBB);
    }

    public static void mount(Entity entity, Entity vehicle) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        net.minecraft.server.v1_14_R1.Entity nmsVehicle = ((CraftEntity)vehicle).getHandle();
        nmsEntity.a(nmsVehicle, true);
    }

    public static Entity getRider(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        net.minecraft.server.v1_14_R1.Entity nmsRider = nmsEntity.getRidingPassenger();
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        CraftEntity rider = CraftEntity.getEntity((CraftServer)craftServer, (net.minecraft.server.v1_14_R1.Entity)nmsRider);
        return rider;
    }

    public static Entity getRootVehicle(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        net.minecraft.server.v1_14_R1.Entity nmsRider = nmsEntity.getRootVehicle();
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        CraftEntity vehicle = CraftEntity.getEntity((CraftServer)craftServer, (net.minecraft.server.v1_14_R1.Entity)nmsRider);
        return vehicle;
    }

    public static Boolean isVehicle(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isVehicle();
    }

    public static Boolean isPassenger(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isPassenger();
    }

    public static Boolean isInteractable(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isInteractable();
    }

    public static Boolean isBurning(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isBurning();
    }

    public static Boolean isFireProof(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isFireProof();
    }

    public static Boolean isWet(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isInWaterOrRain();
    }

    public static Boolean canUseTrident(Player player) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)player).getHandle();
        return nmsEntity.isInWaterOrRain();
    }

    public static Boolean isInWater(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isInWater();
    }

    public static void setInvisible(Entity entity, Boolean bool) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setInvisible(bool.booleanValue());
    }

    public static void setSwimming(Entity entity, Boolean bool) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setSwimming(bool.booleanValue());
    }

    public static Boolean isSwimming(Entity entity) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isSwimming();
    }

    public static void setLocation(Entity entity, Location location) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Double x = location.getX();
        Double y = location.getY();
        Double z = location.getZ();
        Float a0 = Float.valueOf(location.getYaw());
        Float a1 = Float.valueOf(location.getPitch());
        nmsEntity.setLocation(x.doubleValue(), y.doubleValue(), z.doubleValue(), a0.floatValue(), a1.floatValue());
    }

    public static void setPosition(Entity entity, Location location) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Double x = location.getX();
        Double y = location.getY();
        Double z = location.getZ();
        nmsEntity.setPosition(x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public static void setSilent(Entity entity, Boolean bool) {
        net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setSilent(bool.booleanValue());
    }

    public static CraftEntity craftEntity(Entity entity) {
        return (CraftEntity)entity;
    }

    public static net.minecraft.server.v1_14_R1.Entity nmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public static EntityInsentient entityInsentient(Entity entity) {
        return (EntityInsentient)((CraftEntity)entity).getHandle();
    }

    public static EntityInsentient entityInsentient(net.minecraft.server.v1_14_R1.Entity entity) {
        return (EntityInsentient)entity;
    }

    public static EntityAnimal entityAnimal(Entity entity) {
        return (EntityAnimal)((CraftEntity)entity).getHandle();
    }

    public static EntityAnimal entityAnimal(net.minecraft.server.v1_14_R1.Entity entity) {
        return (EntityAnimal)entity;
    }

    public static EntityCreature entityCreature(Entity entity) {
        return (EntityCreature)((CraftEntity)entity).getHandle();
    }

    public static EntityCreature entityCreature(net.minecraft.server.v1_14_R1.Entity entity) {
        return (EntityCreature)entity;
    }
}

