/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Trade Uses")
@Description(value={"The current uses of a merchant recipe."})
@Examples(value={"set the uses of {_trade} to 0"})
@Since(value="0.3.0")
public class ExprUses
extends PropertyExpression<MerchantRecipe, Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number[] get(Event e, MerchantRecipe[] recipes) {
        return (Number[])Arrays.stream(recipes).map(recipe -> recipe.getUses()).toArray(Number[]::new);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the uses of " + this.getExpr().toString(e, debug);
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        Integer changeValue = ((Number)delta[0]).intValue();
        switch (mode) {
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setUses(recipe.getMaxUses() + changeValue);
                }
                break;
            }
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setUses(recipe.getMaxUses() - changeValue);
                }
                break;
            }
            case SET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setUses(changeValue.intValue());
                }
                break;
            }
            case RESET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setUses(0);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprUses.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] use[s] of %merchantrecipes%", "%merchantrecipes%'[s] use[s]"});
    }
}

