/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Trade Price Multiplier")
@Description(value={"The price multiplier of a trade."})
@Examples(value={"set the price multiplier of {_trade} to 1"})
@Since(value="0.3.0")
public class ExprPriceMultiplier
extends PropertyExpression<MerchantRecipe, Integer> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Integer[] get(Event e, MerchantRecipe[] recipes) {
        return (Integer[])Arrays.stream(recipes).map(recipe -> Float.valueOf(recipe.getPriceMultiplier())).toArray(Integer[]::new);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the price multiplier of " + this.getExpr().toString(e, debug);
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        Integer changeValue = (Integer)delta[0];
        switch (mode) {
            case ADD: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setPriceMultiplier((float)(recipe.getMaxUses() + changeValue));
                }
                break;
            }
            case REMOVE: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setPriceMultiplier((float)(recipe.getMaxUses() - changeValue));
                }
                break;
            }
            case SET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setPriceMultiplier((float)changeValue.intValue());
                }
                break;
            }
            case RESET: {
                for (MerchantRecipe recipe : (MerchantRecipe[])this.getExpr().getArray(e)) {
                    recipe.setPriceMultiplier(1.0f);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprPriceMultiplier.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] price multiplier of %merchantrecipes%", "%merchantrecipes%'[s] price multiplier"});
    }
}

