/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;

@Name(value="Set Villager Type")
@Description(value={"Sets the type of a villager."})
@Examples(value={"set type of villager {_v} to \"PLAINS\"", "set type of villager {_v} to \"SWAMP\"", "set type of villager {_v} to \"JUNGLE\"", "set type of villager {_v} to \"SAVANNA\"", "set type of villager {_v} to \"DESERT\"", "set type of villager {_v} to \"SNOW\"", "set type of villager {_v} to \"TAIGA\""})
@Since(value="1.0.0")
public class EffSetVillagerType
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<String> stringExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.stringExpression = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (Entity entity : (Entity[])this.entityExpression.getArray(e)) {
            if (!(entity instanceof Villager)) continue;
            Villager trader = (Villager)entity;
            MerchantUtils.setType(trader, (String)this.stringExpression.getSingle(e));
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set the type of " + this.entityExpression.toString(e, debug) + " to " + this.stringExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetVillagerType.class, (String[])new String[]{"set [the] type of [villager] %entities% to %string%"});
    }
}

