/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;

@Name(value="Set Villager Profession")
@Description(value={"Sets the profession of a villager."})
@Examples(value={"set profession of villager {_v} to \"FARMER\""})
@Since(value="1.0.0")
public class EffSetVillagerProfession
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<String> stringExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.stringExpression = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (Entity entity : (Entity[])this.entityExpression.getArray(e)) {
            if (!(entity instanceof Villager)) continue;
            Villager trader = (Villager)entity;
            MerchantUtils.setProfession(trader, (String)this.stringExpression.getSingle(e));
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set the profession of " + this.entityExpression.toString(e, debug) + " to " + this.stringExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetVillagerProfession.class, (String[])new String[]{"set [the] (prof[ession]|job) of [villager] %entities% to %string%"});
    }
}

