/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;

@Name(value="Set Villager Experience")
@Description(value={"Sets the trading experience of a villager."})
@Examples(value={"set experience of villager {_v} to 5"})
@Since(value="1.0.0")
public class EffSetVillagerExperience
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Number> numberExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.numberExpression = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (Entity entity : (Entity[])this.entityExpression.getArray(e)) {
            if (!(entity instanceof Villager)) continue;
            Villager trader = (Villager)entity;
            MerchantUtils.setExperience(trader, (Number)this.numberExpression.getSingle(e));
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set the exp of " + this.entityExpression.toString(e, debug) + " to " + this.numberExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetVillagerExperience.class, (String[])new String[]{"set [the] [e]xp[erience] of [villager] %entities% to %number%"});
    }
}

