/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Set Trades")
@Description(value={"Sets the trades of a merchant."})
@Examples(value={"set trades of merchant {_m} to {_r::*}"})
@Since(value="0.1.5")
public class EffSetTrades
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Boolean entity;
    private Expression<MerchantRecipe> merchantRecipeExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[0];
        } else {
            this.merchantExpression = exprs[0];
        }
        this.merchantRecipeExpression = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        MerchantRecipe[] trades = (MerchantRecipe[])this.merchantRecipeExpression.getArray(e);
        if (this.entity.booleanValue() && this.entityExpression.getSingle(e) != null) {
            if (this.entityExpression.getSingle(e) instanceof Villager) {
                Villager trader = (Villager)this.entityExpression.getSingle(e);
                MerchantUtils.setRecipes((Merchant)trader, trades);
            } else if (this.entityExpression.getSingle(e) instanceof WanderingTrader) {
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(e);
                MerchantUtils.setRecipes((Merchant)trader, trades);
            }
        } else {
            Merchant trader = (Merchant)this.merchantExpression.getSingle(e);
            MerchantUtils.setRecipes(trader, trades);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "set the trades of " + this.entityExpression.toString(e, debug) + " to " + this.merchantRecipeExpression.toString(e, debug);
        }
        return "set the trades of " + this.merchantExpression.toString(e, debug) + " to " + this.merchantRecipeExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetTrades.class, (String[])new String[]{"set [(the|all)] (trade|recipe)[s] of [merchant] %merchant% to %merchantrecipes%", "set [(the|all)] (trade|recipe)[s] of [(villager|[wandering ]trader)] %entity% to %merchantrecipes%"});
    }
}

