/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Set Trade")
@Description(value={"Sets the trade of a merchant.", "Use this to REPLACE an existing trade.", "New trades must be added."})
@Examples(value={"set trade 1 of merchant {_m} to {_recipe}"})
@Since(value="0.1.5")
public class EffSetTrade
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Boolean entity;
    private Expression<MerchantRecipe> merchantRecipeExpression;
    private Expression<Number> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[1];
        } else {
            this.merchantExpression = exprs[1];
        }
        this.integer = exprs[0];
        this.merchantRecipeExpression = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        MerchantRecipe recipe = (MerchantRecipe)this.merchantRecipeExpression.getSingle(event);
        int index = ((Number)this.integer.getSingle(event)).intValue();
        if (this.entity.booleanValue()) {
            if (this.entityExpression.getSingle(event) instanceof Villager) {
                Villager trader = (Villager)this.entityExpression.getSingle(event);
                if (-1 < index && index < trader.getRecipeCount()) {
                    trader.setRecipe(index, recipe);
                }
            } else if (this.entityExpression.getSingle(event) instanceof WanderingTrader) {
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(event);
                if (-1 < index && index < trader.getRecipeCount()) {
                    trader.setRecipe(index, recipe);
                }
            }
        } else {
            Merchant trader = (Merchant)this.merchantExpression.getSingle(event);
            if (-1 < index && index < trader.getRecipeCount()) {
                trader.setRecipe(index, recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "set trade " + this.integer.toString(e, debug) + " of " + this.entityExpression.toString(e, debug) + " to " + this.merchantRecipeExpression.toString(e, debug);
        }
        return "set trade " + this.integer.toString(e, debug) + " of " + this.merchantExpression.toString(e, debug) + " to " + this.merchantRecipeExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetTrade.class, (String[])new String[]{"set trade %number% of [merchant] %merchant% to %merchantrecipe%", "set trade %number% of [(villager|[wandering ]trader)] %entity% to %merchantrecipe%"});
    }
}

