/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Open Merchant")
@Description(value={"Opens a merchant to players.\n  - Can be used to open the same merchant to multiple players.\n  - Careful, this might break stuff.\n  - This can technically be used to open Wandering Traders as well."})
@Examples(value={"open merchant {_m} to player", "open merchant {auction-list} to all players"})
@Since(value="0.1.5")
public class EffOpenMerchant
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Boolean entity;
    private Expression<Player> playerExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[0];
        } else {
            this.merchantExpression = exprs[0];
        }
        this.playerExpression = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        block5: {
            block3: {
                block4: {
                    if (!this.entity.booleanValue()) break block3;
                    if (!(this.entityExpression.getSingle(e) instanceof Villager)) break block4;
                    Villager trader = (Villager)this.entityExpression.getSingle(e);
                    for (Player player : (Player[])this.playerExpression.getArray(e)) {
                        player.openMerchant(trader, true);
                    }
                    break block5;
                }
                if (!(this.entityExpression.getSingle(e) instanceof WanderingTrader)) break block5;
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(e);
                for (Player player : (Player[])this.playerExpression.getArray(e)) {
                    player.openMerchant((Merchant)trader, true);
                }
                break block5;
            }
            Merchant trader = (Merchant)this.merchantExpression.getSingle(e);
            for (Player player : (Player[])this.playerExpression.getArray(e)) {
                player.openMerchant(trader, true);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "open " + this.entityExpression.toString(e, debug) + " to " + this.playerExpression.toString(e, debug);
        }
        return "open " + this.merchantExpression.toString(e, debug) + " to " + this.playerExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenMerchant.class, (String[])new String[]{"open merchant %merchant% to %players%", "open (villager|[wandering ]trader) %entity% to %players%"});
    }
}

