/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Enable Trade")
@Description(value={"Enables a merchant recipe object."})
@Examples(value={"enable {_recipes::*}"})
@Since(value="0.3.5")
public class EffEnableRecipe
extends Effect {
    private Expression<MerchantRecipe> merchantRecipeExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchantRecipeExpression = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        MerchantRecipe[] merchantRecipes;
        for (MerchantRecipe recipe : merchantRecipes = (MerchantRecipe[])this.merchantRecipeExpression.getArray(e)) {
            MerchantUtils.enableRecipe(recipe);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "enable " + this.merchantRecipeExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEnableRecipe.class, (String[])new String[]{"enable %merchantrecipes%"});
    }
}

