/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Enable Trade")
@Description(value={"Enable a trade."})
@Examples(value={"enable trade 0 of merchant {_merchy}"})
@Since(value="0.1.5")
public class EffEnableIndex
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Boolean entity;
    private Expression<Number> number;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[1];
        } else {
            this.merchantExpression = exprs[1];
        }
        this.number = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        if (this.entity.booleanValue()) {
            if (this.entityExpression.getSingle(e) instanceof Villager) {
                Villager trader = (Villager)this.entityExpression.getSingle(e);
                if (-1 < ((Number)this.number.getSingle(e)).intValue() && ((Number)this.number.getSingle(e)).intValue() < trader.getRecipeCount()) {
                    MerchantRecipe recipe = MerchantUtils.getRecipe(trader, (Integer)((Number)this.number.getSingle(e)).intValue());
                    MerchantUtils.enableRecipe(recipe);
                    trader.setRecipe(((Number)this.number.getSingle(e)).intValue(), recipe);
                }
            } else if (this.entityExpression.getSingle(e) instanceof WanderingTrader) {
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(e);
                if (-1 < ((Number)this.number.getSingle(e)).intValue() && ((Number)this.number.getSingle(e)).intValue() < trader.getRecipeCount()) {
                    MerchantRecipe recipe = MerchantUtils.getRecipe(trader, (Integer)((Number)this.number.getSingle(e)).intValue());
                    MerchantUtils.enableRecipe(recipe);
                    trader.setRecipe(((Number)this.number.getSingle(e)).intValue(), recipe);
                }
            }
        } else {
            Merchant trader = (Merchant)this.merchantExpression.getSingle(e);
            if (-1 < ((Number)this.number.getSingle(e)).intValue() && ((Number)this.number.getSingle(e)).intValue() < trader.getRecipeCount()) {
                MerchantRecipe recipe = MerchantUtils.getRecipe(trader, (Integer)((Number)this.number.getSingle(e)).intValue());
                MerchantUtils.enableRecipe(recipe);
                trader.setRecipe(((Number)this.number.getSingle(e)).intValue(), recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "enable trade " + this.number.toString(e, debug) + " of " + this.entityExpression.toString(e, debug);
        }
        return "enable trade " + this.number.toString(e, debug) + " of " + this.merchantExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEnableIndex.class, (String[])new String[]{"enable (trade|recipe) %number% of [merchant] %merchant%", "enable (trade|recipe) %number% of [(villager|[wandering ]trader)] %entity%"});
    }
}

