/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Clear Trades")
@Description(value={"Clears the trades of a merchant/villager."})
@Examples(value={"clear trades of {thingy}"})
@Since(value="0.5")
public class EffClearTrades
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Boolean entity;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[0];
        } else {
            this.merchantExpression = exprs[0];
        }
        return true;
    }

    protected void execute(Event e) {
        if (this.entity.booleanValue() && this.entityExpression.getSingle(e) != null) {
            if (this.entityExpression.getSingle(e) instanceof Villager) {
                Villager trader = (Villager)this.entityExpression.getSingle(e);
                MerchantUtils.clearRecipes((Merchant)trader);
            } else if (this.entityExpression.getSingle(e) instanceof WanderingTrader) {
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(e);
                MerchantUtils.clearRecipes((Merchant)trader);
            }
        } else {
            Merchant trader = (Merchant)this.merchantExpression.getSingle(e);
            MerchantUtils.clearRecipes(trader);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "clear the trades of " + this.entityExpression.toString(e, debug);
        }
        return "clear the trades of " + this.merchantExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffClearTrades.class, (String[])new String[]{"clear [(the|all)] (trade|recipe)[s] of [merchant] %merchant%", "clear [(the|all)] (trade|recipe)[s] of [(villager|[wandering ]trader)] %entity%"});
    }
}

