/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Add Trade")
@Description(value={"Adds a trade to a merchant/villager/trader."})
@Examples(value={"add trades {_r::*} to merchant {Merchant-Mike}", "add trades {trade-list::*} to target entity", "add trades {_t::*} to villager {victor}"})
@Since(value="0.1.5")
public class EffAddRecipe
extends Effect {
    @Nullable
    private Expression<Merchant> merchantExpression;
    @Nullable
    private Expression<Entity> entityExpression;
    private Expression<MerchantRecipe> merchantRecipeExpression;
    private Boolean entity;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = matchedPattern == 1;
        this.merchantRecipeExpression = exprs[0];
        if (this.entity.booleanValue()) {
            this.entityExpression = exprs[1];
        } else {
            this.merchantExpression = exprs[1];
        }
        return true;
    }

    protected void execute(Event e) {
        block5: {
            block3: {
                block4: {
                    if (!this.entity.booleanValue()) break block3;
                    if (!(this.entityExpression.getSingle(e) instanceof Villager)) break block4;
                    Villager trader = (Villager)this.entityExpression.getSingle(e);
                    for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantRecipeExpression.getArray(e)) {
                        MerchantUtils.addRecipe((Merchant)trader, recipe);
                    }
                    break block5;
                }
                if (!(this.entityExpression.getSingle(e) instanceof WanderingTrader)) break block5;
                WanderingTrader trader = (WanderingTrader)this.entityExpression.getSingle(e);
                for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantRecipeExpression.getArray(e)) {
                    MerchantUtils.addRecipe((Merchant)trader, recipe);
                }
                break block5;
            }
            Merchant trader = (Merchant)this.merchantExpression.getSingle(e);
            for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantRecipeExpression.getArray(e)) {
                MerchantUtils.addRecipe(trader, recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.entity.booleanValue()) {
            return "add trades " + this.merchantRecipeExpression.toString(e, debug) + " to " + this.entityExpression.toString(e, debug);
        }
        return "add trades " + this.merchantRecipeExpression.toString(e, debug) + " to " + this.merchantExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAddRecipe.class, (String[])new String[]{"add (trade|recipe)[s] %merchantrecipes% to [merchant] %merchant%", "add (trade|recipe)[s] %merchantrecipes% to [(villager|[wandering ]trader)] %entity%"});
    }
}

