/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.inventory;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

@Name(value="Open Lectern Inventory")
@Description(value={"Open a fake lectern inventory. It will be a blank book. The name has no use currently, other than in getTitle() methods."})
@Examples(value={"open lectern named \"nothiong\" to all players"})
@Since(value="0.2.0")
public class EffOpenLectern
extends Effect {
    private Expression<String> stringExpression;
    private Expression<Player> playerExpression;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.stringExpression = expr[0];
        this.playerExpression = expr[1];
        return true;
    }

    protected void execute(Event event) {
        Player[] players = (Player[])this.playerExpression.getArray(event);
        String string = (String)this.stringExpression.getSingle(event);
        for (Player player : players) {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.LECTERN, (String)string);
            player.openInventory(inventory);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "open lectern named " + this.stringExpression.toString(event, debug) + " to " + this.playerExpression.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffOpenLectern.class, (String[])new String[]{"open lectern named %string% to %players%"});
    }
}

