/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Get Rider/Driver")
@Description(value={"Gets the rider, or driver, of an entity."})
@Examples(value={"set {_d} to the driver of {_boaty}"})
@Since(value="0.2.5")
public class ExprRider
extends SimpleExpression<Entity> {
    private Expression<Entity> entityExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected Entity[] get(Event e) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Entity vehicle = (Entity)this.entityExpression.getSingle(e);
        Entity driver = EntityUtils.getRider(vehicle);
        if (driver != null) {
            entities.add(driver);
        }
        return entities.toArray(new Entity[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the driver of " + this.entityExpression.toString(e, debug);
    }
}

