/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Silence")
@Description(value={"Make an entity silent/noisy."})
@Examples(value={"set silent state of all players to true", "set the silent state of target entity to false"})
@Since(value="0.2.5")
public class EffSilentState
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Boolean> booleanExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.booleanExpression = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities = (Entity[])this.entityExpression.getArray(event);
        Boolean aBoolean = (Boolean)this.booleanExpression.getSingle(event);
        for (Entity entity : entities) {
            EntityUtils.setSilent(entity, aBoolean);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set the silent state of " + this.entityExpression.toString(e, debug) + " to " + this.booleanExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSilentState.class, (String[])new String[]{"set [the] silent state of %entities% to %boolean%"});
    }
}

