/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Visible")
@Description(value={"Make any entity visible. Probably only useful if they were already invisible. :)"})
@Examples(value={"make all players visible", "make target entity visible"})
@Since(value="0.2.5")
public class EffSetVisible
extends Effect {
    private Expression<Entity> entityExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities;
        for (Entity entity : entities = (Entity[])this.entityExpression.getArray(event)) {
            EntityUtils.setInvisible(entity, false);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entityExpression.toString(e, debug) + " visible";
    }

    static {
        Skript.registerEffect(EffSetVisible.class, (String[])new String[]{"make %entities% visible"});
    }
}

