/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Grow Collision Box")
@Description(value={"Grows the entity's server-side collision box. This affects mobility only."})
@Examples(value={"grow collision box of {_stand} by 1"})
@Since(value="0.2.5")
public class EffGrowCollisionBox
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Number> numberExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.numberExpression = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities = (Entity[])this.entityExpression.getArray(event);
        Number size = (Number)this.numberExpression.getSingle(event);
        for (Entity entity : entities) {
            EntityUtils.growHitBox(entity, size);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "grow collision box of " + this.entityExpression.toString(e, debug) + " by " + this.numberExpression.toString(e, debug);
    }
}

