/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.moderocky.misk.utils.EntityUtils;
import org.bukkit.entity.Entity;

@Name(value="Is Fireproof")
@Description(value={"Checks whether an entity can be damaged by fire. Nether entities and things with fire resistance can't be.This only counts default Minecraft behaviour. If you have some strange plugin or system, it might miss it!"})
@Examples(value={"target entity is fireproof"})
@Since(value="0.2.5")
public class CondIsFireProof
extends PropertyCondition<Entity> {
    public boolean check(Entity entity) {
        if (EntityUtils.isFireProof(entity).booleanValue()) {
            return true;
        }
        assert (false);
        return false;
    }

    protected String getPropertyName() {
        return "fireproof";
    }

    static {
        CondIsFireProof.register(CondIsFireProof.class, (String)"fire[ ]proof[ed]", (String)"entities");
    }
}

