/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.moderocky.misk.listeners.AdvOpenListener;
import com.moderocky.misk.listeners.WASDProtocolListener;
import com.moderocky.misk.utils.MerchantUtils;
import com.moderocky.misk.utils.NMSInterface;
import com.moderocky.misk.utils.ReflectionUtils;
import com.moderocky.misk.utils.nms.v1_14_R1;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MiSK
extends JavaPlugin {
    private static MiSK instance;
    private Logger log;
    PluginManager pluginManager;
    SkriptAddon addon;
    private ProtocolManager protocolManager;
    private String packageName = "com.moderocky.misk";
    public static String pluginName;
    private static NMSInterface nmsMethods;

    public void onEnable() {
        this.log = this.getLogger();
        instance = this;
        if (Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            this.addon = Skript.registerAddon((JavaPlugin)instance);
            try {
                if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
                    this.protocolManager = ProtocolLibrary.getProtocolManager();
                    new WASDProtocolListener(this.protocolManager, (Plugin)instance).registerListener();
                    new AdvOpenListener(this.protocolManager, (Plugin)instance).registerListener();
                    this.addon.loadClasses(this.getPackageName(), new String[]{"skript.ProtocolLib"});
                    this.log.info("*  ProtocolLib has been linked!");
                } else {
                    this.log.info("*  ProtocolLib has not been found!");
                }
                this.addon.loadClasses(this.getPackageName(), new String[]{"skript.Paper"});
                this.addon.loadClasses(this.getPackageName(), new String[]{"skript.Spigot"});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.log.info("*  Skript has been linked!");
            this.init();
        } else {
            this.log.info("*  Skript was not found.");
            this.log.info("*  Bye bye... :(");
            this.disablePlugin();
        }
    }

    private boolean setupNMSVersion() {
        String version = ReflectionUtils.getVersion();
        if (version.equals("v1_14_R0.")) {
            nmsMethods = new v1_14_R1();
            this.getLogger().info("It looks like you're deficient! Please update to 1.14.1.");
        } else if (version.equals("v1_14_R1.")) {
            nmsMethods = new v1_14_R1();
            this.getServer().getConsoleSender().sendMessage("Oh good, you're actually using a supported version.");
        } else {
            this.getLogger().warning("It looks like we need to learn to read. This version isn't supported.");
        }
        return nmsMethods != null;
    }

    public static NMSInterface getNMSMethods() {
        return nmsMethods;
    }

    public boolean supported() {
        String version = ReflectionUtils.getVersion();
        return version.equals("v1_14_R0.") || version.equals("v1_14_R1.");
    }

    public void onDisable() {
        instance = null;
        this.log = this.getLogger();
        this.log.info("*  MiSK disabled!");
    }

    private void init() {
        this.log.info("*  MiSK enabled! A plugin by Moderocky.");
        MerchantUtils.setup();
        this.setupNMSVersion();
    }

    private void disablePlugin() {
        this.pluginManager.disablePlugin((Plugin)this);
    }

    public static MiSK getInstance() {
        return instance;
    }

    public MiSK test() {
        return instance;
    }

    public ProtocolManager getProtocol() {
        return this.protocolManager;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static String getPluginName() {
        return pluginName;
    }

    static {
        pluginName = "MiSK";
    }
}

