/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.utils;

import com.moderocky.misk.utils.MerchantNMS;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.server.v1_14_R1.MerchantRecipeList;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantUtils {
    private static Merchant merchant;
    private static MerchantRecipe recipe;
    static TreeMap<String, Merchant> traderList;
    private static List<MerchantRecipe> recipes;
    private static ItemStack item1;
    private static ItemStack item2;
    private static List recipeList;
    private static HumanEntity player;

    public static MerchantRecipe tradeCreator(ItemStack item1, ItemStack item2, ItemStack item3) {
        recipe = new MerchantRecipe(item3, 99999);
        recipe.setVillagerExperience(0);
        recipe.setPriceMultiplier(1.0f);
        recipe.addIngredient(item1);
        recipe.addIngredient(item2);
        return recipe;
    }

    public static MerchantRecipe disableRecipe(MerchantRecipe recipe) {
        recipe.setMaxUses(0);
        return recipe;
    }

    public static MerchantRecipe enableRecipe(MerchantRecipe recipe) {
        recipe.setMaxUses(99999);
        return recipe;
    }

    public static List tradeList() {
        recipes = new ArrayList<MerchantRecipe>();
        return recipes;
    }

    public static List tradeList(MerchantRecipe[] recipes) {
        recipeList = new ArrayList();
        recipeList.add(recipes);
        return recipeList;
    }

    public static void addToList(MerchantRecipe recipe, List list) {
        list.add(recipe);
    }

    public static void clearRecipes(Merchant merchant) {
        ArrayList trades = new ArrayList();
        merchant.setRecipes(trades);
    }

    public static void removeRecipe(Merchant merchant, MerchantRecipe recipe) {
        ArrayList trades = new ArrayList();
        if (merchant.getRecipeCount() > 0) {
            trades.addAll(merchant.getRecipes());
            trades.remove(recipe);
            merchant.setRecipes(trades);
        }
        merchant.setRecipes(trades);
    }

    public static void removeRecipes(Merchant merchant, MerchantRecipe[] recipes) {
        ArrayList trades = new ArrayList();
        if (merchant.getRecipeCount() > 0) {
            trades.addAll(merchant.getRecipes());
            trades.remove(recipes);
            merchant.setRecipes(trades);
        }
        merchant.setRecipes(trades);
    }

    public static void setRecipes(Merchant merchant, MerchantRecipe recipe) {
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        trades.add(recipe);
        merchant.setRecipes(trades);
    }

    public static void setRecipes(Merchant merchant, MerchantRecipe[] recipes) {
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        for (MerchantRecipe recipe : recipes) {
            trades.add(recipe);
        }
        merchant.setRecipes(trades);
    }

    public static void addRecipe(Merchant merchant, MerchantRecipe recipe) {
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        if (merchant.getRecipeCount() > 0) {
            trades.addAll(merchant.getRecipes());
        }
        trades.add(recipe);
        merchant.setRecipes(trades);
    }

    public static void addRecipe(Merchant merchant, MerchantRecipe[] recipes) {
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        if (merchant.getRecipeCount() > 0) {
            trades.addAll(merchant.getRecipes());
        }
        for (MerchantRecipe recipe : recipes) {
            trades.add(recipe);
        }
        merchant.setRecipes(trades);
    }

    public static void setExp(MerchantRecipe recipe, Integer experience) {
        recipe.setVillagerExperience(experience.intValue());
    }

    public static void transferStats(MerchantRecipe oldRecipe, MerchantRecipe recipe) {
        recipe.setVillagerExperience(oldRecipe.getVillagerExperience());
        recipe.setPriceMultiplier(oldRecipe.getPriceMultiplier());
        recipe.setMaxUses(oldRecipe.getMaxUses());
        recipe.setUses(oldRecipe.getUses());
        recipe.setExperienceReward(oldRecipe.hasExperienceReward());
    }

    public static MerchantRecipe recipeWithResult(MerchantRecipe oldRecipe, ItemStack item3) {
        item1 = (ItemStack)oldRecipe.getIngredients().get(1);
        item2 = (ItemStack)oldRecipe.getIngredients().get(2);
        recipe = MerchantUtils.tradeCreator(item1, item2, item3);
        MerchantUtils.transferStats(oldRecipe, recipe);
        return recipe;
    }

    public static void increaseUses(MerchantRecipe recipe) {
        MerchantNMS.asNMSCopy(recipe).increaseUses();
    }

    public static Boolean isDepleted(MerchantRecipe recipe) {
        return MerchantNMS.asNMSCopy(recipe).isFullyUsed();
    }

    public static MerchantRecipeList getMerchantRecipeList(Merchant merchant) {
        return MerchantNMS.asNMSCopy(merchant).getOffers();
    }

    public static void enableRecipe(Merchant merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(99999);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static void enableRecipe(WanderingTrader merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(99999);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static void enableRecipe(Villager merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(99999);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public void disableRecipe(Merchant merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(0);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public void disableRecipe(WanderingTrader merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(0);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public void disableRecipe(Villager merchant, Integer index) {
        recipe = MerchantUtils.getRecipe(merchant, index);
        recipe.setMaxUses(0);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static MerchantRecipe getRecipe(Merchant merchant, Integer index) {
        recipe = merchant.getRecipe(index.intValue());
        return recipe;
    }

    public static MerchantRecipe getRecipe(WanderingTrader merchant, Integer index) {
        recipe = merchant.getRecipe(index.intValue());
        return recipe;
    }

    public static MerchantRecipe getRecipe(Villager merchant, Integer index) {
        recipe = merchant.getRecipe(index.intValue());
        return recipe;
    }

    public static MerchantRecipe recipeWithResult(Merchant merchant, Integer index, ItemStack result) {
        recipe = merchant.getRecipe(index.intValue());
        recipe = MerchantUtils.recipeWithResult(recipe, result);
        return recipe;
    }

    public static MerchantRecipe recipeWithResult(WanderingTrader merchant, Integer index, ItemStack result) {
        recipe = merchant.getRecipe(index.intValue());
        recipe = MerchantUtils.recipeWithResult(recipe, result);
        return recipe;
    }

    public static MerchantRecipe recipeWithResult(Villager merchant, Integer index, ItemStack result) {
        recipe = merchant.getRecipe(index.intValue());
        recipe = MerchantUtils.recipeWithResult(recipe, result);
        return recipe;
    }

    public static void setResult(Merchant merchant, Integer index, ItemStack result) {
        recipe = MerchantUtils.recipeWithResult(merchant, index, result);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static void setResult(WanderingTrader merchant, Integer index, ItemStack result) {
        recipe = MerchantUtils.recipeWithResult(merchant, index, result);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static void setResult(Villager merchant, Integer index, ItemStack result) {
        recipe = MerchantUtils.recipeWithResult(merchant, index, result);
        merchant.setRecipe(index.intValue(), recipe);
    }

    public static HumanEntity getTrader(Merchant merchant) {
        player = merchant.getTrader();
        return player;
    }

    public static HumanEntity getTrader(WanderingTrader merchant) {
        player = merchant.getTrader();
        return player;
    }

    public static HumanEntity getTrader(Villager merchant) {
        player = merchant.getTrader();
        return player;
    }

    public static List getTradeList(Merchant merchant) {
        recipeList = merchant.getRecipes();
        return recipeList;
    }

    public static List getTradeList(WanderingTrader merchant) {
        recipeList = merchant.getRecipes();
        return recipeList;
    }

    public static List getTradeList(Villager merchant) {
        recipeList = merchant.getRecipes();
        return recipeList;
    }

    public static void setTradeList(Merchant merchant, List trades) {
        merchant.setRecipes(trades);
    }

    public static void setTradeList(WanderingTrader merchant, List trades) {
        merchant.setRecipes(trades);
    }

    public static void setTradeList(Villager merchant, List trades) {
        merchant.setRecipes(trades);
    }

    public static Integer getLevel(Villager villager) {
        return villager.getVillagerLevel();
    }

    public static Integer getLevel(WanderingTrader villager) {
        return 0;
    }

    public static Integer getExperience(Villager villager) {
        return villager.getVillagerExperience();
    }

    public static Integer getExperience(WanderingTrader villager) {
        return 0;
    }

    public static void setExperience(Villager villager, Integer integer) {
        villager.setVillagerExperience(integer.intValue());
    }

    public static void setExperience(WanderingTrader villager, Integer integer) {
    }

    public static Merchant merchant() {
        merchant = Bukkit.createMerchant((String)"Merchant");
        return merchant;
    }

    public static Merchant merchant(String title) {
        merchant = Bukkit.createMerchant((String)title);
        return merchant;
    }

    public static Merchant merchant(List recipes) {
        merchant = Bukkit.createMerchant((String)"Merchant");
        merchant.setRecipes(recipes);
        return merchant;
    }

    public static Merchant merchant(String title, List recipes) {
        merchant = Bukkit.createMerchant((String)title);
        merchant.setRecipes(recipes);
        return merchant;
    }

    public static Merchant merchant(String title, MerchantRecipe[] recipes) {
        merchant = Bukkit.createMerchant((String)title);
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        for (MerchantRecipe recipe : recipes) {
            trades.add(recipe);
        }
        merchant.setRecipes(trades);
        return merchant;
    }

    public static Merchant merchant(MerchantRecipe[] recipes) {
        merchant = Bukkit.createMerchant((String)"Merchant");
        ArrayList<MerchantRecipe> trades = new ArrayList<MerchantRecipe>();
        for (MerchantRecipe recipe : recipes) {
            trades.add(recipe);
        }
        merchant.setRecipes(trades);
        return merchant;
    }

    public static void setup() {
        traderList = new TreeMap();
    }

    public static void createMerchant(String id, String name) {
        merchant = Bukkit.createMerchant((String)name);
        traderList.put(id, merchant);
    }

    public static void deleteMerchant(String id) {
        traderList.remove(id);
    }

    public static void saveMerchant(String id, Merchant merchant) {
        traderList.put(id, merchant);
    }

    public static TreeMap getIDList() {
        return traderList;
    }

    public static Merchant merchantFromID(String id) {
        return traderList.get(id);
    }

    public static void openMerchant(Player player, Merchant merchant) {
        player.openMerchant(merchant, true);
    }

    public static void openMerchant(Player player, WanderingTrader merchant) {
        player.openMerchant((Merchant)merchant, false);
    }

    public static void openMerchant(Player player, Villager merchant) {
        player.openMerchant(merchant, false);
    }
}

