/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.utils;

import ch.njol.skript.aliases.ItemType;
import com.moderocky.misk.MiSK;
import com.moderocky.misk.utils.SkriptUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.TreeMap;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemStackUtils {
    static TreeMap<String, ItemStack> customList;
    public static net.minecraft.server.v1_14_R1.ItemStack itemStack;

    public static net.minecraft.server.v1_14_R1.ItemStack createItemStack(NBTTagCompound nbtTagCompound) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = net.minecraft.server.v1_14_R1.ItemStack.class.getDeclaredConstructors()) {
            Object object;
            if (!Modifier.isPrivate(constructor.getModifiers())) continue;
            constructor.setAccessible(true);
            Class<?>[] classes = constructor.getParameterTypes();
            if (constructor.getParameterCount() != 1 || classes[0] != NBTTagCompound.class || !((object = constructor.newInstance(nbtTagCompound)) instanceof net.minecraft.server.v1_14_R1.ItemStack)) continue;
            itemStack = (net.minecraft.server.v1_14_R1.ItemStack)object;
            return itemStack;
        }
        if (itemStack != null) {
            return itemStack;
        }
        return null;
    }

    public static void setModelData(ItemStack itemStack, Integer integer) {
        itemStack.getItemMeta().setCustomModelData(integer);
    }

    public static void setModelData(ItemType itemType, Integer integer) {
        ItemStackUtils.setModelData(SkriptUtils.getItemStack(itemType), integer);
    }

    public static Boolean hasModelData(ItemStack itemStack) {
        return itemStack.getItemMeta().hasCustomModelData();
    }

    public static Boolean hasModelData(ItemType itemType) {
        return SkriptUtils.getItemStack(itemType).getItemMeta().hasCustomModelData();
    }

    public static Integer getModelData(ItemStack itemStack) {
        return itemStack.getItemMeta().getCustomModelData();
    }

    public static Integer getModelData(ItemType itemType) {
        return SkriptUtils.getItemStack(itemType).getItemMeta().getCustomModelData();
    }

    public static void setUnbreakable(ItemStack itemStack, Boolean b) {
        itemStack.getItemMeta().setUnbreakable(b.booleanValue());
    }

    public static void setUnbreakable(ItemType itemType, Boolean b) {
        SkriptUtils.getItemStack(itemType).getItemMeta().setUnbreakable(b.booleanValue());
    }

    public static void setLocalisedName(ItemStack itemStack, String name) {
        itemStack.getItemMeta().setLocalizedName(name);
    }

    public static void setLocalisedName(ItemType itemType, String name) {
        SkriptUtils.getItemStack(itemType).getItemMeta().setLocalizedName(name);
    }

    public static String getLocalisedName(ItemStack itemStack) {
        return itemStack.getItemMeta().getLocalizedName();
    }

    public static String getLocalisedName(ItemType itemType) {
        return SkriptUtils.getItemStack(itemType).getItemMeta().getLocalizedName();
    }

    public static PersistentDataContainer getDataContainer(ItemStack itemStack) {
        return itemStack.getItemMeta().getPersistentDataContainer();
    }

    public static PersistentDataContainer getDataContainer(ItemType itemType) {
        return SkriptUtils.getItemStack(itemType).getItemMeta().getPersistentDataContainer();
    }

    public static void setValue(PersistentDataContainer container, NamespacedKey key, PersistentDataType type, Object value) {
        Class<?> clazz = type.getClass();
        Class trueValue = (Class)clazz.cast(value);
        container.set(key, type, (Object)trueValue);
    }

    public static void setByteValue(PersistentDataContainer container, NamespacedKey key, Byte value) {
        container.set(key, PersistentDataType.BYTE, (Object)value);
    }

    public static void setFloatValue(PersistentDataContainer container, NamespacedKey key, Float value) {
        container.set(key, PersistentDataType.FLOAT, (Object)value);
    }

    public static void setStringValue(PersistentDataContainer container, NamespacedKey key, String value) {
        container.set(key, PersistentDataType.STRING, (Object)value);
    }

    public static void setShortValue(PersistentDataContainer container, NamespacedKey key, Short value) {
        container.set(key, PersistentDataType.SHORT, (Object)value);
    }

    public static void setDoubleValue(PersistentDataContainer container, NamespacedKey key, Double value) {
        container.set(key, PersistentDataType.DOUBLE, (Object)value);
    }

    public static void setIntegerValue(PersistentDataContainer container, NamespacedKey key, Integer value) {
        container.set(key, PersistentDataType.INTEGER, (Object)value);
    }

    public static void setLongValue(PersistentDataContainer container, NamespacedKey key, Long value) {
        container.set(key, PersistentDataType.LONG, (Object)value);
    }

    public static void setContainerValue(PersistentDataContainer container, NamespacedKey key, PersistentDataContainer value) {
        container.set(key, PersistentDataType.TAG_CONTAINER, (Object)value);
    }

    public static NamespacedKey newKey(Plugin plugin, String key) {
        return new NamespacedKey(plugin, key);
    }

    public static NamespacedKey newKey(String plugin, String key) {
        return new NamespacedKey(Bukkit.getPluginManager().getPlugin(plugin), key);
    }

    public static NamespacedKey newMiskKey(String key) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(MiSK.getPluginName());
        return new NamespacedKey(plugin, key);
    }

    public static NamespacedKey newSkriptKey(String key) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Skript");
        return new NamespacedKey(plugin, key);
    }

    public static void setup() {
        customList = new TreeMap();
    }

    public static void deleteEntry(String id) {
        customList.remove(id);
    }

    public static void saveItemStack(String id, ItemStack itemStack) {
        customList.put(id, itemStack);
    }

    public static void saveItemStack(String id, ItemType itemType) {
        ItemStack itemStack = SkriptUtils.getItemStack(itemType);
        customList.put(id, itemStack);
    }

    public static TreeMap getItemList() {
        return customList;
    }

    public static ItemStack getItemStack(String id) {
        if (ItemStackUtils.getItemList().containsKey(id) && (ItemStack)ItemStackUtils.getItemList().get(id) != null) {
            return (ItemStack)ItemStackUtils.getItemList().get(id);
        }
        return new ItemStack(Material.AIR);
    }

    public static ItemType getItemType(String id) {
        if (ItemStackUtils.getItemList().containsKey(id) && (ItemStack)ItemStackUtils.getItemList().get(id) != null) {
            return new ItemType((ItemStack)ItemStackUtils.getItemList().get(id));
        }
        return new ItemType(new ItemStack(Material.AIR));
    }
}

