/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.misc;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.ItemStackUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.v1_14_R1.MojangsonParser;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Displayed Item on Projectile")
@Description(value={"Get itemstack displayed on a snowball/etc."})
@Examples(value={"set {_i} to item of projectile {_e}"})
@Since(value="0.2.0")
public class ExprProjectileItem
extends SimpleExpression<ItemType> {
    private Expression<Entity> entity;
    @Nullable
    private net.minecraft.server.v1_14_R1.ItemStack itemStack;
    @Nullable
    private NBTTagCompound nbtTagCompound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = exprs[0];
        return true;
    }

    protected ItemType[] get(Event event) {
        ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
        if (this.entity.getSingle(event) instanceof Snowball || this.entity.getSingle(event) instanceof EnderPearl || this.entity.getSingle(event) instanceof Egg || this.entity.getSingle(event) instanceof ThrownExpBottle || this.entity.getSingle(event) instanceof ThrownPotion) {
            net.minecraft.server.v1_14_R1.Entity nmsEntity = ((CraftEntity)this.entity).getHandle();
            NBTTagCompound nbt = new NBTTagCompound();
            nmsEntity.c(nbt);
            if (nbt.get("Item") != null) {
                String itemString = nbt.get("Item").toString();
                try {
                    this.nbtTagCompound = MojangsonParser.parse((String)itemString);
                    if (this.nbtTagCompound != null) {
                        this.itemStack = ItemStackUtils.createItemStack(this.nbtTagCompound);
                    }
                }
                catch (CommandSyntaxException | IllegalAccessException | InstantiationException | InvocationTargetException throwable) {
                    // empty catch block
                }
                if (this.itemStack != null) {
                    itemTypes.add(new ItemType(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)this.itemStack)));
                    return itemTypes.toArray(new ItemType[0]);
                }
            }
        }
        itemTypes.add(new ItemType(new ItemStack(Material.AIR)));
        return itemTypes.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "item of projectile " + this.entity.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprProjectileItem.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] item (of|displayed on) [projectile] %entity%"});
    }
}

