/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.misc;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.MiSK;
import com.moderocky.misk.utils.Laser;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@Name(value="Draw Laser")
@Description(value={"Draw a client-side guardian laser."})
@Examples(value={"draw laser from player to target block for 5 seconds"})
@Since(value="0.2.5")
public class EffDrawLaser
extends Effect {
    private Expression<Location> location1;
    private Expression<Location> location2;
    private Expression<Integer> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location1 = exprs[0];
        this.location2 = exprs[1];
        this.integer = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        Location from = (Location)this.location1.getSingle(e);
        Location to = (Location)this.location2.getSingle(e);
        Integer time = (Integer)this.integer.getSingle(e);
        if (from.getWorld() == to.getWorld() && from.distance(to) < 100.0) {
            try {
                Laser laser = new Laser(from, to, time, 100);
                laser.start((Plugin)MiSK.getInstance());
            }
            catch (ReflectiveOperationException exception) {
                exception.printStackTrace();
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "draw laser from " + this.location1.toString(e, debug) + " to " + this.location2.toString(e, debug) + " for " + this.integer.toString(e, debug) + " seconds";
    }

    static {
        Skript.registerEffect(EffDrawLaser.class, (String[])new String[]{"draw (guardian beam|laser) from %location% to %location% [[and] keep] for %integer% second[s]"});
    }
}

