/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Create ID-Based Merchant")
@Description(value={"Creates an ID-Based merchant.", "These are saved to a list."})
@Examples(value={"create merchant with id \"bob\" named \"Bob the Merchant\""})
@Since(value="0.1.5")
public class EffCreateIDMerchant
extends Effect {
    private Expression<String> string1;
    private Expression<String> string2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.string1 = exprs[0];
        this.string2 = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        String name = (String)this.string1.getSingle(e);
        String id = (String)this.string2.getSingle(e);
        if (MerchantUtils.getIDList().containsKey(id)) {
            MerchantUtils.deleteMerchant(id);
        }
        MerchantUtils.createMerchant(id, name);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "create merchant " + this.string1.toString(e, debug) + " named " + this.string2.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCreateIDMerchant.class, (String[])new String[]{"create [a] [new] merchant [with id] %string% named %string%"});
    }
}

