/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Set Location / Move Entity")
@Description(value={"Move an entity. This will take all passengers/hangers-on with the entity. MUST be in the same world."})
@Examples(value={"move player's vehicle to {spawn-point}"})
@Since(value="0.2.5")
public class EffSetLocation
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Location> locationExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.locationExpression = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities = (Entity[])this.entityExpression.getArray(event);
        Location location = (Location)this.locationExpression.getSingle(event);
        for (Entity entity : entities) {
            if (entity.getWorld() != location.getWorld()) continue;
            EntityUtils.setLocation(entity, location);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "move " + this.entityExpression.toString(e, debug) + " to " + this.locationExpression.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetLocation.class, (String[])new String[]{"move %entities% to %location%"});
    }
}

