/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Invisible")
@Description(value={"Make any entity invisible. Sometimes, this doesn't work in the same tick as spawning it."})
@Examples(value={"make {_pigs::*} invisible", "make target entity invisible"})
@Since(value="0.2.5")
public class EffSetInvisible
extends Effect {
    private Expression<Entity> entityExpression;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities;
        for (Entity entity : entities = (Entity[])this.entityExpression.getArray(event)) {
            EntityUtils.setInvisible(entity, true);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entityExpression.toString(e, debug) + " invisible";
    }

    static {
        Skript.registerEffect(EffSetInvisible.class, (String[])new String[]{"make %entities% invisible"});
    }
}

