/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Set Collision Box Size")
@Description(value={"Set the entity's server-side collision box. This affects mobility only."})
@Examples(value={"set collision box of {_stand} to 3 wide and 2 tall"})
@Since(value="0.2.5")
public class EffSetCollisionBox
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Number> numberExpression;
    @Nullable
    private Expression<Number> numberExpression2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.numberExpression = exprs[1];
        this.numberExpression2 = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities = (Entity[])this.entityExpression.getArray(event);
        Number width = (Number)this.numberExpression.getSingle(event);
        Number height = (Number)this.numberExpression.getSingle(event);
        if (this.numberExpression2.getSingle(event) != null) {
            height = (Number)this.numberExpression2.getSingle(event);
        }
        for (Entity entity : entities) {
            EntityUtils.setHitBox(entity, width, height);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.numberExpression2.toString(e, debug) != null) {
            return "set collision box of " + this.entityExpression.toString(e, debug) + " to " + this.numberExpression.toString(e, debug) + " wide and " + this.numberExpression2.toString(e, debug) + " tall";
        }
        return "set collision box of " + this.entityExpression.toString(e, debug) + " to " + this.numberExpression.toString(e, debug) + " wide and " + this.numberExpression.toString(e, debug) + " tall";
    }
}

