/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Force Mount")
@Description(value={"Forces an entity to mount another. Be careful! All of these entities will send vehicle steer packets to the server. Use it wisely."})
@Examples(value={"mount {_pigs::*} on {_stand}", "mount all players on target entity"})
@Since(value="0.2.5")
public class EffMount
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Entity> entityExpression1;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        this.entityExpression1 = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entities = (Entity[])this.entityExpression.getArray(event);
        Entity target = (Entity)this.entityExpression1.getSingle(event);
        for (Entity entity : entities) {
            EntityUtils.mount(entity, target);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "mount " + this.entityExpression.toString(e, debug) + " on " + this.entityExpression1.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffMount.class, (String[])new String[]{"mount %entities% on %entity%"});
    }
}

