/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;

@Name(value="Merchant Recipe Count")
@Description(value={"Get the number of trades of a merchant"})
@Examples(value={"set {_n} to the trade count of merchant {bob}"})
@Since(value="0.1.5")
public class ExprRecipeCount
extends SimpleExpression<Integer> {
    private Expression<Entity> entity;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = exprs[0];
        return true;
    }

    protected Integer[] get(Event e) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (this.entity.getSingle(e) instanceof Villager) {
            Villager trader = (Villager)this.entity.getSingle(e);
            integers.add(trader.getRecipeCount());
            return integers.toArray(new Integer[0]);
        }
        if (this.entity.getSingle(e) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(e);
            integers.add(trader.getRecipeCount());
            return integers.toArray(new Integer[0]);
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the trade count of merchant " + this.entity.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprRecipeCount.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (recipe|trade) count of [villager] %entity%"});
    }
}

