/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Set Trades")
@Description(value={"Sets the trades of a villager."})
@Examples(value={"set trades of villager {_v} to {_r::*}"})
@Since(value="0.1.5")
public class EffSetTrades
extends Effect {
    private Expression<Entity> entity;
    private Expression<MerchantRecipe> merchantrecipes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = exprs[0];
        this.merchantrecipes = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        MerchantRecipe[] trades = (MerchantRecipe[])this.merchantrecipes.getArray(e);
        if (this.entity.getSingle(e) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(e);
            MerchantUtils.setRecipes((Merchant)trader, trades);
        } else if (this.entity.getSingle(e) instanceof Villager) {
            Villager trader = (Villager)this.entity.getSingle(e);
            MerchantUtils.setRecipes((Merchant)trader, trades);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set the trades of villager " + this.entity.toString(e, debug) + " to " + this.merchantrecipes.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetTrades.class, (String[])new String[]{"set [(the|all)] (trade|recipe)[s] of villager %entity% to %merchantrecipes%"});
    }
}

