/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Set Villager Trade")
@Description(value={"Sets the trade of a villager.", "Use this to REPLACE an existing trade.", "New trades must be added."})
@Examples(value={"set trade 1 of villager {_v} to {_recipe}"})
@Since(value="0.1.5")
public class EffSetTrade
extends Effect {
    private Expression<Entity> entity;
    private Expression<MerchantRecipe> merchantrecipe;
    private Expression<Integer> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.integer = exprs[0];
        this.entity = exprs[1];
        this.merchantrecipe = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        MerchantRecipe recipe = (MerchantRecipe)this.merchantrecipe.getSingle(event);
        Integer index = (Integer)this.integer.getSingle(event);
        if (this.entity.getSingle(event) instanceof Villager) {
            Villager trader = (Villager)this.entity.getSingle(event);
            if (0 < index && index < trader.getRecipeCount()) {
                trader.setRecipe(index.intValue(), recipe);
            }
        } else if (this.entity.getSingle(event) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(event);
            if (0 < index && index < trader.getRecipeCount()) {
                trader.setRecipe(index.intValue(), recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "set trade " + this.integer.toString(e, debug) + " of villager " + this.entity.toString(e, debug) + " to " + this.merchantrecipe.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSetTrade.class, (String[])new String[]{"set trade %integer% of villager %entity% to %merchantrecipe%"});
    }
}

