/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Add Trade")
@Description(value={"Adds a trade to a villager."})
@Examples(value={"add trades {_r::*} to villager {_v}"})
@Since(value="0.1.5")
public class EffAddRecipe
extends Effect {
    private Expression<Entity> entity;
    private Expression<MerchantRecipe> merchantrecipes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchantrecipes = exprs[0];
        this.entity = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        block3: {
            block2: {
                if (!(this.entity.getSingle(e) instanceof Villager)) break block2;
                Villager trader = (Villager)this.entity.getSingle(e);
                for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantrecipes.getArray(e)) {
                    MerchantUtils.addRecipe((Merchant)trader, recipe);
                }
                break block3;
            }
            if (!(this.entity.getSingle(e) instanceof WanderingTrader)) break block3;
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(e);
            for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantrecipes.getArray(e)) {
                MerchantUtils.addRecipe((Merchant)trader, recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "add " + this.merchantrecipes.toString(e, debug) + " to " + this.entity.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAddRecipe.class, (String[])new String[]{"add (trade|recipe)[s] %merchantrecipes% to villager %entity%"});
    }
}

