/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.misc;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.skript.Spigot.misc.ExprProjectileItem;
import com.moderocky.misk.utils.ItemStackUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.v1_14_R1.MojangsonParser;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Item From String")
@Description(value={"Get the item from an NBT string, such as returned from Minecraft's /data command"})
@Examples(value={"set {_i} to item from nbt string {_string}"})
@Since(value="0.2.0")
public class ExprItemFromNBT
extends SimpleExpression<ItemType> {
    private Expression<String> string;
    private net.minecraft.server.v1_14_R1.ItemStack itemStack;
    private NBTTagCompound nbtTagCompound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.string = exprs[0];
        return true;
    }

    protected ItemType[] get(Event event) {
        ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
        try {
            this.nbtTagCompound = MojangsonParser.parse((String)((String)this.string.getSingle(event)));
            if (this.nbtTagCompound != null) {
                this.itemStack = ItemStackUtils.createItemStack(this.nbtTagCompound);
            }
        }
        catch (CommandSyntaxException | IllegalAccessException | InstantiationException | InvocationTargetException throwable) {
            // empty catch block
        }
        if (this.itemStack != null) {
            itemTypes.add(new ItemType(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)this.itemStack)));
            return itemTypes.toArray(new ItemType[0]);
        }
        itemTypes.add(new ItemType(new ItemStack(Material.AIR)));
        return itemTypes.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "item from nbt " + this.string.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprProjectileItem.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] item (from|of) nbt [string] %string%"});
    }
}

