/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.misc;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Pathfind to Location")
@Description(value={"Make an animal walk to a location."})
@Examples(value={"make {_pig} walk to {_location} at speed 0.6"})
@Since(value="0.2.0")
public class EffPathfind
extends Effect {
    private static final Double DEFAULT_SPEED = 1.0;
    private Expression<LivingEntity> entityExpression;
    @Nullable
    private Expression<Number> numberExpression;
    private Expression<Location> locationExpression;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.entityExpression = expr[0];
        this.locationExpression = expr[1];
        this.numberExpression = expr[2];
        return true;
    }

    protected void execute(Event event) {
        LivingEntity[] entities;
        Number v = this.numberExpression != null ? (Number)((Number)this.numberExpression.getSingle(event)) : (Number)DEFAULT_SPEED;
        Double speed = v;
        if (speed == null) {
            return;
        }
        Location location = (Location)this.locationExpression.getSingle(event);
        for (LivingEntity entity : entities = (LivingEntity[])this.entityExpression.getAll(event)) {
            EntityUtils.moveToPosition((Entity)entity, location, speed);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.numberExpression.getSingle(event) != null) {
            return "make " + this.entityExpression.toString(event, debug) + " walk to " + this.locationExpression.toString(event, debug) + " at speed " + this.numberExpression.toString(event, debug);
        }
        return "make " + this.entityExpression.toString(event, debug) + " walk to " + this.locationExpression.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffPathfind.class, (String[])new String[]{"make %livingentities% (pathfind|walk) to %location% [at speed %-number%]"});
    }
}

