/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.misc;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.EntityUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Pathfind to Entity")
@Description(value={"Make an animal walk to an entity."})
@Examples(value={"make {_pig} walk to player at speed 0.6"})
@Since(value="0.2.0")
public class EffMoveToTarget
extends Effect {
    private static final Double DEFAULT_SPEED = 1.0;
    private Expression<LivingEntity> entityExpression;
    private Expression<Entity> entityExpression2;
    @Nullable
    private Expression<Number> numberExpression;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.entityExpression = expr[0];
        this.entityExpression2 = expr[1];
        this.numberExpression = expr[2];
        return true;
    }

    protected void execute(Event event) {
        LivingEntity[] entities;
        Number v = this.numberExpression != null ? (Number)((Number)this.numberExpression.getSingle(event)) : (Number)DEFAULT_SPEED;
        Double speed = v;
        if (speed == null) {
            return;
        }
        Entity target = (Entity)this.entityExpression2.getSingle(event);
        for (LivingEntity entity : entities = (LivingEntity[])this.entityExpression.getAll(event)) {
            EntityUtils.moveToPosition((Entity)entity, target, speed);
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.numberExpression.getSingle(event) != null) {
            return "make " + this.entityExpression.toString(event, debug) + " walk to " + this.entityExpression2.toString(event, debug) + " at speed " + this.numberExpression.toString(event, debug);
        }
        return "make " + this.entityExpression.toString(event, debug) + " walk to " + this.entityExpression2.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffMoveToTarget.class, (String[])new String[]{"make %livingentities% (pathfind|walk) to %entity% [at speed %-number%]"});
    }
}

